/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFACreationUtils;
import org.sosy_lab.cpachecker.cfa.FunctionCallCollector;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.MutableCFA;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodOrConstructorInvocation;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.CFATerminationNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.java.JMethodCallEdge;
import org.sosy_lab.cpachecker.cfa.model.java.JMethodEntryNode;
import org.sosy_lab.cpachecker.cfa.model.java.JMethodReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.java.JMethodSummaryEdge;
import org.sosy_lab.cpachecker.cfa.types.IAFunctionType;
import org.sosy_lab.cpachecker.exceptions.CParserException;
import org.sosy_lab.cpachecker.exceptions.JParserException;
import org.sosy_lab.cpachecker.exceptions.ParserException;
import org.sosy_lab.cpachecker.util.CFATraversal;

@Options
public class CFASecondPassBuilder {
    @Option(secure=true, name="analysis.summaryEdges", description="create summary call statement edges")
    private boolean summaryEdges = false;
    @Option(secure=true, name="cfa.assumeFunctions", description="Which functions should be interpreted as encoding assumptions")
    private Set<String> assumeFunctions = ImmutableSet.of((Object)"__VERIFIER_assume");
    protected final MutableCFA cfa;
    protected final Language language;
    protected final LogManager logger;

    public CFASecondPassBuilder(MutableCFA pCfa, Language pLanguage, LogManager pLogger, Configuration config) throws InvalidConfigurationException {
        this.cfa = pCfa;
        this.language = pLanguage;
        this.logger = pLogger;
        config.inject((Object)this);
    }

    public void insertCallEdgesRecursively() throws ParserException {
        FunctionCallCollector visitor = new FunctionCallCollector();
        for (FunctionEntryNode entryNode : this.cfa.getAllFunctionHeads()) {
            CFATraversal.dfs().traverseOnce(entryNode, visitor);
        }
        for (AStatementEdge functionCall : visitor.getFunctionCalls()) {
            if (functionCall.getPredecessor().getNumEnteringEdges() == 0) continue;
            this.insertCallEdges(functionCall);
        }
    }

    private void insertCallEdges(AStatementEdge statementEdge) throws ParserException {
        AFunctionCall call = (AFunctionCall)statementEdge.getStatement();
        if (this.shouldCreateCallEdges(call)) {
            this.createCallAndReturnEdges(statementEdge, call);
        } else {
            this.replaceBuiltinFunction(statementEdge, call);
            this.applyAttributes(statementEdge, call);
        }
    }

    private boolean shouldCreateCallEdges(AFunctionCall call) {
        AFunctionDeclaration functionDecl = call.getFunctionCallExpression().getDeclaration();
        return functionDecl != null && this.cfa.getAllFunctionNames().contains(functionDecl.getName());
    }

    private void createCallAndReturnEdges(AStatementEdge edge, AFunctionCall functionCall) throws ParserException {
        CFANode predecessorNode = edge.getPredecessor();
        assert (predecessorNode.getLeavingSummaryEdge() == null);
        CFANode successorNode = edge.getSuccessor();
        if (successorNode.getEnteringSummaryEdge() != null) {
            CFANode tmp = new CFANode(successorNode.getFunction());
            tmp.setReversePostorderId(predecessorNode.getReversePostorderId());
            this.cfa.addNode(tmp);
            BlankEdge tmpEdge = new BlankEdge("", FileLocation.DUMMY, tmp, successorNode, "");
            CFACreationUtils.addEdgeUnconditionallyToCFA(tmpEdge);
            successorNode = tmp;
        }
        AFunctionCallExpression functionCallExpression = functionCall.getFunctionCallExpression();
        String functionName = functionCallExpression.getDeclaration().getName();
        FileLocation fileLocation = edge.getFileLocation();
        FunctionEntryNode fDefNode = this.cfa.getFunctionHead(functionName);
        FunctionExitNode fExitNode = fDefNode.getExitNode();
        if (!this.checkParamSizes(functionCallExpression, fDefNode.getFunctionDefinition().getType())) {
            int declaredParameters = fDefNode.getFunctionDefinition().getType().getParameters().size();
            int actualParameters = functionCallExpression.getParameterExpressions().size();
            switch (this.language) {
                case JAVA: {
                    throw new JParserException("Function " + functionName + " takes " + declaredParameters + " parameter(s) but is called with " + actualParameters + " parameter(s)", edge);
                }
                case C: {
                    throw new CParserException("Method " + functionName + " takes " + declaredParameters + " parameter(s) but is called with " + actualParameters + " parameter(s)", edge);
                }
            }
            throw new AssertionError((Object)("Unhandled language " + this.language));
        }
        CFACreationUtils.removeEdgeFromNodes(edge);
        FunctionSummaryEdge calltoReturnEdge = null;
        FunctionCallEdge callEdge = null;
        switch (this.language) {
            case C: {
                if (this.summaryEdges) {
                    CFunctionSummaryStatementEdge summaryStatementEdge = new CFunctionSummaryStatementEdge(edge.getRawStatement(), (CFunctionCall)functionCall, fileLocation, predecessorNode, successorNode, (CFunctionCall)functionCall, fDefNode.getFunctionName());
                    predecessorNode.addLeavingEdge(summaryStatementEdge);
                    successorNode.addEnteringEdge(summaryStatementEdge);
                }
                calltoReturnEdge = new CFunctionSummaryEdge(edge.getRawStatement(), fileLocation, predecessorNode, successorNode, (CFunctionCall)functionCall, (CFunctionEntryNode)fDefNode);
                callEdge = new CFunctionCallEdge(edge.getRawStatement(), fileLocation, predecessorNode, (CFunctionEntryNode)fDefNode, (CFunctionCall)functionCall, (CFunctionSummaryEdge)calltoReturnEdge);
                break;
            }
            case JAVA: {
                calltoReturnEdge = new JMethodSummaryEdge(edge.getRawStatement(), fileLocation, predecessorNode, successorNode, (JMethodOrConstructorInvocation)functionCall, (JMethodEntryNode)fDefNode);
                callEdge = new JMethodCallEdge(edge.getRawStatement(), fileLocation, predecessorNode, (JMethodEntryNode)fDefNode, (JMethodOrConstructorInvocation)functionCall, (JMethodSummaryEdge)calltoReturnEdge);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        predecessorNode.addLeavingSummaryEdge(calltoReturnEdge);
        successorNode.addEnteringSummaryEdge(calltoReturnEdge);
        predecessorNode.addLeavingEdge(callEdge);
        fDefNode.addEnteringEdge(callEdge);
        if (fExitNode.getNumEnteringEdges() == 0) {
            CFACreationUtils.removeChainOfNodesFromCFA(successorNode);
        } else {
            FunctionReturnEdge returnEdge;
            switch (this.language) {
                case C: {
                    returnEdge = new CFunctionReturnEdge(fileLocation, fExitNode, successorNode, (CFunctionSummaryEdge)calltoReturnEdge);
                    break;
                }
                case JAVA: {
                    returnEdge = new JMethodReturnEdge(fileLocation, fExitNode, successorNode, (JMethodSummaryEdge)calltoReturnEdge);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            fExitNode.addLeavingEdge(returnEdge);
            successorNode.addEnteringEdge(returnEdge);
        }
    }

    private boolean checkParamSizes(AFunctionCallExpression functionCallExpression, IAFunctionType functionType) {
        List<? extends AExpression> parameters = functionCallExpression.getParameterExpressions();
        int declaredParameters = functionType.getParameters().size();
        int actualParameters = parameters.size();
        return functionType.takesVarArgs() && declaredParameters <= actualParameters || declaredParameters == actualParameters;
    }

    private void replaceBuiltinFunction(AStatementEdge edge, AFunctionCall call) {
        if (!(edge instanceof CStatementEdge)) {
            return;
        }
        AFunctionCallExpression f = call.getFunctionCallExpression();
        if (f.getDeclaration() == null) {
            return;
        }
        String name = f.getDeclaration().getName();
        if (!this.assumeFunctions.contains(name)) {
            return;
        }
        if (f.getParameterExpressions().size() != 1) {
            this.logger.logf(Level.WARNING, "Ignoring call to %s with illegal number of parameters (%s).", new Object[]{name, f.getParameterExpressions().size()});
            return;
        }
        if (call instanceof AFunctionCallAssignmentStatement) {
            this.logger.logf(Level.WARNING, "Ignoring non-void call to %s.", new Object[]{name});
            return;
        }
        CExpression assumeExp = (CExpression)f.getParameterExpressions().get(0);
        if (!(assumeExp instanceof CBinaryExpression) || !((CBinaryExpression)assumeExp).getOperator().isLogicalOperator()) {
            assumeExp = new CBinaryExpressionBuilder(this.cfa.getMachineModel(), this.logger).buildBinaryExpressionUnchecked(assumeExp, CIntegerLiteralExpression.ZERO, CBinaryExpression.BinaryOperator.NOT_EQUALS);
        }
        CAssumeEdge trueEdge = new CAssumeEdge(edge.getRawStatement(), edge.getFileLocation(), edge.getPredecessor(), edge.getSuccessor(), assumeExp, true);
        CFATerminationNode elseNode = new CFATerminationNode(edge.getPredecessor().getFunction());
        CAssumeEdge falseEdge = new CAssumeEdge(edge.getRawStatement(), edge.getFileLocation(), edge.getPredecessor(), elseNode, assumeExp, false);
        CFACreationUtils.removeEdgeFromNodes(edge);
        this.cfa.addNode(elseNode);
        CFACreationUtils.addEdgeUnconditionallyToCFA(trueEdge);
        CFACreationUtils.addEdgeUnconditionallyToCFA(falseEdge);
    }

    private void applyAttributes(AStatementEdge edge, AFunctionCall call) {
        if (!(edge instanceof CStatementEdge)) {
            return;
        }
        CStatementEdge cEdge = (CStatementEdge)edge;
        AFunctionCallExpression f = call.getFunctionCallExpression();
        AFunctionDeclaration decl = f.getDeclaration();
        if (decl == null) {
            return;
        }
        String name = decl.getName();
        if (this.isAbortingFunction(decl)) {
            if (call instanceof AFunctionCallAssignmentStatement) {
                this.logger.logf(Level.WARNING, "Function-call assignment with non-returning method %s.", new Object[]{name});
            }
            CFATerminationNode terminationNode = new CFATerminationNode(edge.getPredecessor().getFunction());
            CStatementEdge edgeToTermination = new CStatementEdge(cEdge.getRawStatement(), cEdge.getStatement(), cEdge.getFileLocation(), cEdge.getPredecessor(), (CFANode)terminationNode);
            CFACreationUtils.removeEdgeFromNodes(edge);
            CFACreationUtils.removeChainOfNodesFromCFA(edge.getSuccessor());
            this.cfa.addNode(terminationNode);
            CFACreationUtils.addEdgeUnconditionallyToCFA(edgeToTermination);
        }
    }

    private boolean isAbortingFunction(AFunctionDeclaration pDecl) {
        return pDecl instanceof CFunctionDeclaration && ((CFunctionDeclaration)pDecl).doesNotReturn();
    }
}

