/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import java.nio.file.Path;
import java.util.List;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CProgramScope;
import org.sosy_lab.cpachecker.cfa.CSourceOriginMapping;
import org.sosy_lab.cpachecker.cfa.ParseResult;
import org.sosy_lab.cpachecker.cfa.Parser;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.parser.Parsers;
import org.sosy_lab.cpachecker.cfa.parser.Scope;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.exceptions.CParserException;

public interface CParser
extends Parser {
    @Override
    default public ParseResult parseString(Path filename, String code) throws CParserException, InterruptedException {
        return this.parseString(filename, code, new CSourceOriginMapping(), CProgramScope.empty());
    }

    public ParseResult parseString(List<FileContentToParse> var1, CSourceOriginMapping var2) throws CParserException, InterruptedException;

    public ParseResult parseString(Path var1, String var2, CSourceOriginMapping var3, Scope var4) throws CParserException, InterruptedException;

    public CAstNode parseSingleStatement(String var1, Scope var2) throws CParserException, InterruptedException;

    public List<CAstNode> parseStatements(String var1, Scope var2) throws CParserException, InterruptedException;

    public static class Factory {
        public static ParserOptions getOptions(Configuration config) throws InvalidConfigurationException {
            Parsers.EclipseCParserOptions result = new Parsers.EclipseCParserOptions();
            config.recursiveInject((Object)result);
            return result;
        }

        public static ParserOptions getDefaultOptions() {
            return new Parsers.EclipseCParserOptions();
        }

        public static CParser getParser(LogManager logger, ParserOptions options, MachineModel machine, ShutdownNotifier shutdownNotifier) {
            return Parsers.getCParser(logger, (Parsers.EclipseCParserOptions)options, machine, shutdownNotifier);
        }
    }

    @Options(prefix="parser")
    public static abstract class ParserOptions {
        @Option(secure=true, description="C dialect for parser")
        private Dialect dialect = Dialect.GNUC;
        @Option(secure=true, description="Whether to collect ACSL annotations if present")
        private boolean collectACSLAnnotations = false;

        protected ParserOptions() {
        }

        public Dialect getDialect() {
            return this.dialect;
        }

        public boolean shouldCollectACSLAnnotations() {
            return this.collectACSLAnnotations;
        }
    }

    public static enum Dialect {
        C99,
        GNUC;

    }

    public static class FileContentToParse
    extends FileToParse {
        private final String fileContent;

        public FileContentToParse(Path pFileName, String pFileContent) {
            super(pFileName);
            this.fileContent = pFileContent;
        }

        public String getFileContent() {
            return this.fileContent;
        }
    }

    public static class FileToParse {
        private final Path fileName;

        public FileToParse(Path pFileName) {
            this.fileName = pFileName;
        }

        public Path getFileName() {
            return this.fileName;
        }
    }
}

