/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.common.truth.Truth8;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.Path;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CParser;
import org.sosy_lab.cpachecker.cfa.CParserWithLocationMapper;
import org.sosy_lab.cpachecker.cfa.CSourceOriginMapping;
import org.sosy_lab.cpachecker.cfa.ParseResult;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.exceptions.CParserException;

@RunWith(value=Parameterized.class)
public class CParserLocationTest {
    @Parameterized.Parameter(value=0)
    public String fileName;
    @Parameterized.Parameter(value=1)
    public String expectedFileName;
    private CParser parser;

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> testcases() {
        return ImmutableList.of((Object)new Object[]{"test.c", "./test.c"}, (Object)new Object[]{"./test.c", "./test.c"}, (Object)new Object[]{"dir/test.c", "dir/test.c"}, (Object)new Object[]{"./dir/test.c", "./dir/test.c"}, (Object)new Object[]{"/dir/test.c", "/dir/test.c"});
    }

    @Before
    public void createParser() {
        this.parser = CParser.Factory.getParser(LogManager.createTestLogManager(), CParser.Factory.getDefaultOptions(), MachineModel.LINUX32, ShutdownNotifier.createDummy());
    }

    @Test
    public void singleFileTest() throws CParserException, InterruptedException {
        String code = "void main() { }";
        ParseResult result = this.parser.parseString(Path.of(this.fileName, new String[0]), code);
        FileLocation mainLoc = ((FunctionEntryNode)result.getFunctions().get("main")).getFileLocation();
        Truth8.assertThat((Path)mainLoc.getFileName()).isEqualTo((Object)Path.of(this.expectedFileName, new String[0]));
        Truth.assertThat((String)mainLoc.getNiceFileName()).isEmpty();
        Truth.assertThat((Integer)mainLoc.getStartingLineNumber()).isEqualTo((Object)1);
        Truth.assertThat((Integer)mainLoc.getEndingLineNumber()).isEqualTo((Object)1);
        Truth.assertThat((Integer)mainLoc.getStartingLineInOrigin()).isEqualTo((Object)1);
        Truth.assertThat((Integer)mainLoc.getEndingLineInOrigin()).isEqualTo((Object)1);
    }

    @Test
    public void singleFileTest_lineDirectiveIgnored() throws Exception {
        this.parser = new CParserWithLocationMapper(Configuration.defaultConfiguration(), LogManager.createTestLogManager(), this.parser, false);
        String code = "#line 5 \"foo.c\"\nvoid main() { }";
        ParseResult result = this.parser.parseString(Path.of(this.fileName, new String[0]), code);
        FileLocation mainLoc = ((FunctionEntryNode)result.getFunctions().get("main")).getFileLocation();
        Truth8.assertThat((Path)mainLoc.getFileName()).isEqualTo((Object)Path.of(this.expectedFileName, new String[0]));
        Truth.assertThat((String)mainLoc.getNiceFileName()).isEmpty();
        Truth.assertThat((Integer)mainLoc.getStartingLineNumber()).isEqualTo((Object)2);
        Truth.assertThat((Integer)mainLoc.getEndingLineNumber()).isEqualTo((Object)2);
        Truth.assertThat((Integer)mainLoc.getStartingLineInOrigin()).isEqualTo((Object)2);
        Truth.assertThat((Integer)mainLoc.getEndingLineInOrigin()).isEqualTo((Object)2);
    }

    @Test
    public void singleFileTest_lineDirective() throws Exception {
        this.parser = new CParserWithLocationMapper(Configuration.defaultConfiguration(), LogManager.createTestLogManager(), this.parser, true);
        String code = "#line 5\nvoid main() { }";
        ParseResult result = this.parser.parseString(Path.of(this.fileName, new String[0]), code);
        FileLocation mainLoc = ((FunctionEntryNode)result.getFunctions().get("main")).getFileLocation();
        Truth8.assertThat((Path)mainLoc.getFileName()).isEqualTo((Object)Path.of(this.expectedFileName, new String[0]));
        Truth.assertThat((String)mainLoc.getNiceFileName()).isEmpty();
        Truth.assertThat((Integer)mainLoc.getStartingLineNumber()).isEqualTo((Object)2);
        Truth.assertThat((Integer)mainLoc.getEndingLineNumber()).isEqualTo((Object)2);
        Truth.assertThat((Integer)mainLoc.getStartingLineInOrigin()).isEqualTo((Object)5);
        Truth.assertThat((Integer)mainLoc.getEndingLineInOrigin()).isEqualTo((Object)5);
    }

    @Test
    public void singleFileTest_lineDirectiveWithFilename() throws Exception {
        this.parser = new CParserWithLocationMapper(Configuration.defaultConfiguration(), LogManager.createTestLogManager(), this.parser, true);
        String code = "#line 5 \"foo.c\"\nvoid main() { }";
        ParseResult result = this.parser.parseString(Path.of(this.fileName, new String[0]), code);
        FileLocation mainLoc = ((FunctionEntryNode)result.getFunctions().get("main")).getFileLocation();
        Truth8.assertThat((Path)mainLoc.getFileName()).isEqualTo((Object)Path.of("foo.c", new String[0]));
        Truth.assertThat((String)mainLoc.getNiceFileName()).isEqualTo((Object)"foo.c");
        Truth.assertThat((Integer)mainLoc.getStartingLineNumber()).isEqualTo((Object)2);
        Truth.assertThat((Integer)mainLoc.getEndingLineNumber()).isEqualTo((Object)2);
        Truth.assertThat((Integer)mainLoc.getStartingLineInOrigin()).isEqualTo((Object)5);
        Truth.assertThat((Integer)mainLoc.getEndingLineInOrigin()).isEqualTo((Object)5);
    }

    @Test
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public void multiFileTest() throws CParserException, InterruptedException {
        String mainCode = "void main() { }";
        CParser.FileContentToParse main = new CParser.FileContentToParse(Path.of(this.fileName, new String[0]), mainCode);
        String additionalCode = "void foo() { }";
        String additionalFileName = this.fileName.replace("test", "additional");
        String expectedAdditionalFileName = this.expectedFileName.replace("test", "additional");
        CParser.FileContentToParse additional = new CParser.FileContentToParse(Path.of(additionalFileName, new String[0]), additionalCode);
        ParseResult result = this.parser.parseString((List<CParser.FileContentToParse>)ImmutableList.of((Object)main, (Object)additional), new CSourceOriginMapping());
        FileLocation mainLoc = ((FunctionEntryNode)result.getFunctions().get("main")).getFileLocation();
        Truth8.assertThat((Path)mainLoc.getFileName()).isEqualTo((Object)Path.of(this.expectedFileName, new String[0]));
        Truth.assertThat((String)mainLoc.getNiceFileName()).isEqualTo((Object)Path.of(this.expectedFileName, new String[0]).getFileName().toString());
        Truth.assertThat((Integer)mainLoc.getStartingLineNumber()).isEqualTo((Object)1);
        Truth.assertThat((Integer)mainLoc.getEndingLineNumber()).isEqualTo((Object)1);
        Truth.assertThat((Integer)mainLoc.getStartingLineInOrigin()).isEqualTo((Object)1);
        Truth.assertThat((Integer)mainLoc.getEndingLineInOrigin()).isEqualTo((Object)1);
        FileLocation additionalLoc = ((FunctionEntryNode)result.getFunctions().get("foo")).getFileLocation();
        Truth8.assertThat((Path)additionalLoc.getFileName()).isEqualTo((Object)Path.of(expectedAdditionalFileName, new String[0]));
        Truth.assertThat((String)additionalLoc.getNiceFileName()).isEqualTo((Object)Path.of(expectedAdditionalFileName, new String[0]).getFileName().toString());
        Truth.assertThat((Integer)additionalLoc.getStartingLineNumber()).isEqualTo((Object)1);
        Truth.assertThat((Integer)additionalLoc.getEndingLineNumber()).isEqualTo((Object)1);
        Truth.assertThat((Integer)additionalLoc.getStartingLineInOrigin()).isEqualTo((Object)1);
        Truth.assertThat((Integer)additionalLoc.getEndingLineInOrigin()).isEqualTo((Object)1);
    }
}

