/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.cdt.core.parser.OffsetLimitReachedException;
import org.eclipse.cdt.internal.core.parser.scanner.ILexerLog;
import org.eclipse.cdt.internal.core.parser.scanner.Lexer;
import org.eclipse.cdt.internal.core.parser.scanner.Token;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CParser;
import org.sosy_lab.cpachecker.cfa.CSourceOriginMapping;
import org.sosy_lab.cpachecker.cfa.ParseResult;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.parser.Scope;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.c.BOMParser;
import org.sosy_lab.cpachecker.exceptions.CParserException;

@Options
public class CParserWithLocationMapper
implements CParser {
    private final CParser realParser;
    private final LogManager logger;
    private final boolean readLineDirectives;
    @Option(secure=true, name="locmapper.dumpTokenizedProgramToFile", description="Write the tokenized version of the input program to this file.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path dumpTokenizedProgramToFile = null;
    @Option(secure=true, name="parser.transformTokensToLines", description="Preprocess the given C files before parsing: Put every single token onto a new line. Then the line number corresponds to the token number.")
    private boolean tokenizeCode = false;

    public CParserWithLocationMapper(Configuration pConfig, LogManager pLogger, CParser pRealParser, boolean pReadLineDirectives) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = pLogger;
        this.realParser = pRealParser;
        this.readLineDirectives = pReadLineDirectives;
    }

    private String tokenizeSourcefile(Path pFilename, CSourceOriginMapping sourceOriginMapping) throws CParserException, IOException {
        String code = BOMParser.filterAndDecode(pFilename);
        return this.processCode(pFilename, code, sourceOriginMapping);
    }

    private String processCode(Path fileName, String pCode, CSourceOriginMapping sourceOriginMapping) throws CParserException {
        String code;
        StringBuilder tokenizedCode = new StringBuilder();
        Lexer.LexerOptions options = new Lexer.LexerOptions();
        ILexerLog log = ILexerLog.NULL;
        Object source = null;
        Lexer lx = new Lexer(pCode.toCharArray(), options, log, source);
        try {
            Token token;
            int absoluteLineNumber;
            int relativeLineNumber = absoluteLineNumber = 1;
            Path rangeLinesOriginFilename = fileName;
            int includeStartedWithAbsoluteLine = 1;
            while ((token = lx.nextToken()).getType() != 144) {
                if (token.getType() == -99) {
                    ++absoluteLineNumber;
                    ++relativeLineNumber;
                }
                if (token.getType() == 138) {
                    ArrayList<Token> directiveTokens = new ArrayList<Token>();
                    token = lx.nextToken();
                    while (token.getType() != -99 && token.getType() != 144) {
                        directiveTokens.add(token);
                        token = lx.nextToken();
                    }
                    ++absoluteLineNumber;
                    ++relativeLineNumber;
                    if (!this.readLineDirectives || directiveTokens.isEmpty()) continue;
                    String firstTokenImage = ((Token)directiveTokens.get(0)).getImage().trim();
                    int lineNumberTokenIndex = directiveTokens.size() > 1 && firstTokenImage.equals("line") && ((Token)directiveTokens.get(1)).getImage().matches("[0-9]+") ? 1 : (firstTokenImage.matches("[0-9]+") ? 0 : -1);
                    if (lineNumberTokenIndex < 0) continue;
                    sourceOriginMapping.mapInputLineRangeToDelta(fileName, rangeLinesOriginFilename, includeStartedWithAbsoluteLine, absoluteLineNumber, relativeLineNumber - absoluteLineNumber);
                    String lineNumberToken = ((Token)directiveTokens.get(lineNumberTokenIndex)).getImage().trim();
                    includeStartedWithAbsoluteLine = absoluteLineNumber;
                    relativeLineNumber = Integer.parseInt(lineNumberToken);
                    if (directiveTokens.size() <= lineNumberTokenIndex + 1) continue;
                    String file = ((Token)directiveTokens.get(lineNumberTokenIndex + 1)).getImage().trim();
                    if (file.charAt(0) == '\"' && file.charAt(file.length() - 1) == '\"') {
                        file = file.substring(1, file.length() - 1);
                    }
                    rangeLinesOriginFilename = Path.of(file, new String[0]);
                    continue;
                }
                if (token.getImage().trim().isEmpty() || !this.tokenizeCode) continue;
                tokenizedCode.append(token.toString());
                tokenizedCode.append(System.lineSeparator());
            }
            if (this.readLineDirectives) {
                sourceOriginMapping.mapInputLineRangeToDelta(fileName, rangeLinesOriginFilename, includeStartedWithAbsoluteLine, absoluteLineNumber + 1, relativeLineNumber - absoluteLineNumber);
            }
        }
        catch (OffsetLimitReachedException e) {
            throw new CParserException("Tokenizing failed", e);
        }
        String string = code = this.tokenizeCode ? tokenizedCode.toString() : pCode;
        if (this.tokenizeCode && this.dumpTokenizedProgramToFile != null) {
            try (Writer out = IO.openOutputFile((Path)this.dumpTokenizedProgramToFile, (Charset)StandardCharsets.US_ASCII, (OpenOption[])new OpenOption[0]);){
                out.append(code);
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write tokenized program to file");
            }
        }
        return code;
    }

    @Override
    public ParseResult parseString(Path pFilename, String pCode, CSourceOriginMapping pSourceOriginMapping, Scope pScope) throws CParserException, InterruptedException {
        String tokenizedCode = this.processCode(pFilename, pCode, pSourceOriginMapping);
        return this.realParser.parseString(pFilename, tokenizedCode, pSourceOriginMapping, pScope);
    }

    @Override
    public Timer getParseTime() {
        return this.realParser.getParseTime();
    }

    @Override
    public Timer getCFAConstructionTime() {
        return this.realParser.getCFAConstructionTime();
    }

    @Override
    public ParseResult parseFiles(List<String> pFilenames) throws CParserException, IOException, InterruptedException {
        CSourceOriginMapping sourceOriginMapping = new CSourceOriginMapping();
        ArrayList<CParser.FileContentToParse> programFragments = new ArrayList<CParser.FileContentToParse>(pFilenames.size());
        for (String f : pFilenames) {
            Path path = Path.of(f, new String[0]);
            String programCode = this.tokenizeSourcefile(path, sourceOriginMapping);
            if (programCode.isEmpty()) {
                throw new CParserException("Tokenizer returned empty program");
            }
            programFragments.add(new CParser.FileContentToParse(path, programCode));
        }
        return this.realParser.parseString(programFragments, sourceOriginMapping);
    }

    @Override
    public ParseResult parseString(List<CParser.FileContentToParse> pCode, CSourceOriginMapping sourceOriginMapping) throws CParserException, InterruptedException {
        ArrayList<CParser.FileContentToParse> tokenizedFragments = new ArrayList<CParser.FileContentToParse>(pCode.size());
        for (CParser.FileContentToParse f : pCode) {
            String programCode = this.processCode(f.getFileName(), f.getFileContent(), sourceOriginMapping);
            if (programCode.isEmpty()) {
                throw new CParserException("Tokenizer returned empty program");
            }
            tokenizedFragments.add(new CParser.FileContentToParse(f.getFileName(), programCode));
        }
        return this.realParser.parseString(tokenizedFragments, sourceOriginMapping);
    }

    @Override
    public CAstNode parseSingleStatement(String pCode, Scope pScope) throws CParserException, InterruptedException {
        return this.realParser.parseSingleStatement(pCode, pScope);
    }

    @Override
    public List<CAstNode> parseStatements(String pCode, Scope pScope) throws CParserException, InterruptedException {
        return this.realParser.parseStatements(pCode, pScope);
    }
}

