/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CParser;
import org.sosy_lab.cpachecker.cfa.CPreprocessor;
import org.sosy_lab.cpachecker.cfa.CSourceOriginMapping;
import org.sosy_lab.cpachecker.cfa.ParseResult;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.parser.Scope;
import org.sosy_lab.cpachecker.exceptions.CParserException;
import org.sosy_lab.cpachecker.exceptions.ParserException;

class CParserWithPreprocessor
implements CParser {
    private final CParser realParser;
    private final CPreprocessor preprocessor;

    public CParserWithPreprocessor(CParser pRealParser, CPreprocessor pPreprocessor) {
        this.realParser = pRealParser;
        this.preprocessor = pPreprocessor;
    }

    @Override
    public ParseResult parseString(Path pFilename, String pCode, CSourceOriginMapping pSourceOriginMapping, Scope pScope) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Timer getParseTime() {
        return this.realParser.getParseTime();
    }

    @Override
    public Timer getCFAConstructionTime() {
        return this.realParser.getCFAConstructionTime();
    }

    @Override
    public ParseResult parseFiles(List<String> pFilenames) throws ParserException, InterruptedException {
        ArrayList<CParser.FileContentToParse> programs = new ArrayList<CParser.FileContentToParse>(pFilenames.size());
        for (String f : pFilenames) {
            Path path = Path.of(f, new String[0]);
            String programCode = this.preprocessor.preprocess(path);
            if (programCode.isEmpty()) {
                throw new CParserException("Preprocessor returned empty program");
            }
            programs.add(new CParser.FileContentToParse(path, programCode));
        }
        return this.realParser.parseString(programs, new CSourceOriginMapping());
    }

    @Override
    public ParseResult parseString(List<CParser.FileContentToParse> pCode, CSourceOriginMapping sourceOriginMapping) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CAstNode parseSingleStatement(String pCode, Scope pScope) throws CParserException, InterruptedException {
        return this.realParser.parseSingleStatement(pCode, pScope);
    }

    @Override
    public List<CAstNode> parseStatements(String pCode, Scope pScope) throws CParserException, InterruptedException {
        return this.realParser.parseStatements(pCode, pScope);
    }
}

