/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.ast.AAstNode;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDefDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.parser.Scope;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBitFieldType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypedefType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.cfa.types.c.DefaultCTypeVisitor;
import org.sosy_lab.cpachecker.exceptions.NoException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;

public class CProgramScope
implements Scope {
    public static final String ARTIFICIAL_RETVAL_NAME = "__artificial_result__";
    private final String currentFile = "";
    private final Set<String> variableNames;
    private final Multimap<String, CSimpleDeclaration> simpleDeclarations;
    private final Multimap<String, CFunctionDeclaration> functionDeclarations;
    private final Multimap<String, CSimpleDeclaration> qualifiedDeclarations;
    private final Map<String, CType> qualifiedTypeDefs;
    private final Map<String, CComplexType> qualifiedTypes;
    private final Map<String, CSimpleDeclaration> retValDeclarations;
    private final Multimap<CAstNode, FileLocation> uses;
    private final String functionName;
    private final Predicate<FileLocation> locationDescriptor;

    private static Iterable<CSimpleDeclaration> toCSimpleDeclarations(CFANode pNode) {
        return CFAUtils.leavingEdges(pNode).transformAndConcat(pEdge -> {
            if (pEdge.getEdgeType() == CFAEdgeType.DeclarationEdge) {
                CDeclaration dcl = ((CDeclarationEdge)pEdge).getDeclaration();
                return Collections.singleton(dcl);
            }
            if (pNode instanceof FunctionEntryNode) {
                FunctionEntryNode entryNode = (FunctionEntryNode)pNode;
                return FluentIterable.from(entryNode.getFunctionParameters()).filter(CSimpleDeclaration.class);
            }
            return ImmutableSet.of();
        });
    }

    private static boolean hasName(CSimpleDeclaration pDeclaration) {
        if (pDeclaration.getName() != null && pDeclaration.getQualifiedName() != null) {
            return true;
        }
        if (pDeclaration.getName() == null && pDeclaration.getQualifiedName() == null && pDeclaration instanceof CComplexTypeDeclaration) {
            CComplexTypeDeclaration complexTypeDeclaration = (CComplexTypeDeclaration)pDeclaration;
            CComplexType complexType = complexTypeDeclaration.getType();
            return complexType != null && complexType.getName() != null && complexType.getQualifiedName() != null;
        }
        return false;
    }

    private static String getName(CSimpleDeclaration pDeclaration) {
        CComplexTypeDeclaration complexTypeDeclaration;
        CComplexType complexType;
        String result = pDeclaration.getName();
        if (result != null) {
            return result;
        }
        if (pDeclaration instanceof CComplexTypeDeclaration && (complexType = (complexTypeDeclaration = (CComplexTypeDeclaration)pDeclaration).getType()) != null && complexType.getName() != null && complexType.getQualifiedName() != null) {
            return complexType.getName();
        }
        throw new AssertionError((Object)"Cannot extract a name.");
    }

    private static String getOriginalQualifiedName(CSimpleDeclaration pDeclaration) {
        String name = pDeclaration.getName();
        if (name == null) {
            return CProgramScope.getComplexDeclarationName(pDeclaration);
        }
        String originalName = pDeclaration.getOrigName();
        String qualifiedName = pDeclaration.getQualifiedName();
        if (name.equals(originalName)) {
            return qualifiedName;
        }
        assert (qualifiedName.endsWith(name));
        return qualifiedName.substring(0, qualifiedName.length() - name.length()) + originalName;
    }

    private static String getComplexDeclarationName(CSimpleDeclaration pDeclaration) {
        CComplexType complexType;
        if (pDeclaration instanceof CComplexTypeDeclaration && (complexType = ((CComplexTypeDeclaration)pDeclaration).getType()) != null) {
            String name = complexType.getName();
            String originalName = complexType.getOrigName();
            String qualifiedName = complexType.getQualifiedName();
            if (name.equals(originalName)) {
                return qualifiedName;
            }
            assert (qualifiedName.endsWith(name));
            return qualifiedName.substring(0, qualifiedName.length() - name.length()) + originalName;
        }
        throw new AssertionError((Object)"Cannot extract a name.");
    }

    private CProgramScope() {
        this.variableNames = ImmutableSet.of();
        this.qualifiedDeclarations = ImmutableListMultimap.of();
        this.simpleDeclarations = ImmutableListMultimap.of();
        this.functionDeclarations = ImmutableListMultimap.of();
        this.qualifiedTypes = ImmutableMap.of();
        this.qualifiedTypeDefs = ImmutableMap.of();
        this.retValDeclarations = ImmutableMap.of();
        this.uses = ImmutableListMultimap.of();
        this.functionName = null;
        this.locationDescriptor = Predicates.alwaysTrue();
    }

    private CProgramScope(CProgramScope pScope, String pFunctionName, Predicate<FileLocation> pLocationDescriptor) {
        this.variableNames = pScope.variableNames;
        this.simpleDeclarations = pScope.simpleDeclarations;
        this.functionDeclarations = pScope.functionDeclarations;
        this.qualifiedDeclarations = pScope.qualifiedDeclarations;
        this.qualifiedTypes = pScope.qualifiedTypes;
        this.qualifiedTypeDefs = pScope.qualifiedTypeDefs;
        this.retValDeclarations = pScope.retValDeclarations;
        this.uses = pScope.uses;
        this.functionName = pFunctionName;
        this.locationDescriptor = pLocationDescriptor;
    }

    public CProgramScope(CFA pCFA, LogManager pLogger) {
        assert (pCFA.getLanguage() == Language.C || pCFA.getLanguage() == Language.LLVM);
        this.functionName = null;
        this.locationDescriptor = Predicates.alwaysTrue();
        Collection<CFANode> nodes = pCFA.getAllNodes();
        FluentIterable allDcls = FluentIterable.from(nodes).transformAndConcat(CProgramScope::toCSimpleDeclarations);
        FluentIterable dcls = allDcls.filter(CProgramScope::hasName);
        FluentIterable functionDcls = dcls.filter(CFunctionDeclaration.class);
        FluentIterable nonFunctionDcls = dcls.filter(Predicates.not((com.google.common.base.Predicate)Predicates.instanceOf(CFunctionDeclaration.class)));
        FluentIterable typeDcls = dcls.filter(CTypeDeclaration.class);
        this.qualifiedTypes = CProgramScope.extractTypes((FluentIterable<? extends CSimpleDeclaration>)nonFunctionDcls, pLogger);
        this.qualifiedTypeDefs = CProgramScope.extractTypeDefs((FluentIterable<CTypeDeclaration>)typeDcls, pLogger);
        this.functionDeclarations = functionDcls.index(CProgramScope::getOriginalQualifiedName);
        HashMap<String, CSimpleDeclaration> artificialRetValDeclarations = new HashMap<String, CSimpleDeclaration>();
        for (CFunctionDeclaration functionDeclaration : this.functionDeclarations.values()) {
            String name;
            if (functionDeclaration.getType().getReturnType().getCanonicalType() instanceof CVoidType || artificialRetValDeclarations.containsKey(name = functionDeclaration.getName())) continue;
            CSimpleDeclaration retValDecl = CProgramScope.getArtificialFunctionReturnVariable(functionDeclaration);
            artificialRetValDeclarations.put(name, retValDecl);
        }
        this.retValDeclarations = Collections.unmodifiableMap(artificialRetValDeclarations);
        nonFunctionDcls = FluentIterable.from((Iterable)Iterables.concat((Iterable)nonFunctionDcls, artificialRetValDeclarations.values()));
        this.variableNames = nonFunctionDcls.transform(CProgramScope::getName).toSet();
        this.qualifiedDeclarations = CProgramScope.extractQualifiedDeclarations((FluentIterable<CSimpleDeclaration>)nonFunctionDcls);
        this.uses = CProgramScope.extractVarUseLocations(nodes);
        this.simpleDeclarations = CProgramScope.extractSimpleDeclarations(this.qualifiedDeclarations);
    }

    public static CProgramScope empty() {
        return new CProgramScope();
    }

    @Override
    public boolean isGlobalScope() {
        return this.functionName == null;
    }

    @Override
    public boolean variableNameInUse(String pName) {
        return this.variableNames.contains(pName);
    }

    @Override
    public @Nullable CSimpleDeclaration lookupVariable(String pName) {
        ArrayList<Supplier<Iterable>> lookups = new ArrayList<Supplier<Iterable>>(this.isGlobalScope() ? 2 : 3);
        if (!this.isGlobalScope()) {
            lookups.add(() -> this.qualifiedDeclarations.get((Object)this.createScopedNameOf(pName)));
        }
        lookups.add(() -> this.qualifiedDeclarations.get((Object)pName));
        lookups.add(() -> this.simpleDeclarations.get((Object)pName));
        ImmutableSet results = ImmutableSet.of();
        Iterable filteredAndUnfiltered = Iterables.concat((Iterable)Iterables.transform(lookups, s -> () -> this.lambda$lookupVariable$5((Supplier)s)), lookups);
        Iterator lookupSupplierIterator = filteredAndUnfiltered.iterator();
        while (results.size() != 1 && lookupSupplierIterator.hasNext()) {
            results = ImmutableSet.copyOf((Iterable)((Iterable)((Supplier)lookupSupplierIterator.next()).get()));
        }
        CSimpleDeclaration result = null;
        Iterator resultIt = results.iterator();
        if (resultIt.hasNext()) {
            result = (CSimpleDeclaration)resultIt.next();
            if (resultIt.hasNext()) {
                result = null;
            }
        }
        return result;
    }

    @Override
    public @Nullable CFunctionDeclaration lookupFunction(String pName) {
        Iterator it = this.functionDeclarations.get((Object)pName).iterator();
        if (it.hasNext()) {
            return (CFunctionDeclaration)it.next();
        }
        return null;
    }

    @Override
    public @Nullable CComplexType lookupType(String pName) {
        CComplexType result = null;
        if (!this.isGlobalScope()) {
            String functionQualifiedName = this.createScopedNameOf(pName);
            result = CProgramScope.lookupQualifiedComplexType(functionQualifiedName, this.qualifiedTypes);
            if (result != null) {
                return result;
            }
            result = this.qualifiedTypes.get(functionQualifiedName);
            if (result != null) {
                return result;
            }
        }
        if ((result = CProgramScope.lookupQualifiedComplexType(pName, this.qualifiedTypes)) != null) {
            return result;
        }
        result = this.qualifiedTypes.get(pName);
        if (result != null) {
            return result;
        }
        CType typdefResult = this.lookupTypedef(pName);
        if (typdefResult instanceof CComplexType) {
            return (CComplexType)typdefResult;
        }
        return null;
    }

    @Override
    public CType lookupTypedef(String pName) {
        CType result = null;
        if (!this.isGlobalScope()) {
            String functionQualifiedName = this.createScopedNameOf(pName);
            result = CProgramScope.lookupQualifiedComplexType(functionQualifiedName, this.qualifiedTypeDefs);
            if (result != null) {
                return result;
            }
            result = this.qualifiedTypeDefs.get(functionQualifiedName);
            if (result != null) {
                return result;
            }
        }
        if ((result = CProgramScope.lookupQualifiedComplexType(pName, this.qualifiedTypeDefs)) != null) {
            return result;
        }
        return this.qualifiedTypeDefs.get(pName);
    }

    @Override
    public void registerDeclaration(CSimpleDeclaration pDeclaration) {
    }

    @Override
    public boolean registerTypeDeclaration(CComplexTypeDeclaration pDeclaration) {
        return false;
    }

    @Override
    public String createScopedNameOf(String pName) {
        if (!this.isGlobalScope()) {
            return CProgramScope.createScopedNameOf(this.getCurrentFunctionName(), pName);
        }
        return pName;
    }

    private static String createScopedNameOf(String pFunctionName, String pName) {
        return pFunctionName + "::" + pName;
    }

    @Override
    public String getFileSpecificTypeName(String type) {
        if (this.isFileSpecificTypeName(type)) {
            return type;
        }
        String fileSpecificTypeName = type + "__";
        if ("".isEmpty() && this.lookupTypedef(fileSpecificTypeName) == null && this.lookupTypedef(type) != null) {
            return type;
        }
        return fileSpecificTypeName;
    }

    @Override
    public boolean isFileSpecificTypeName(String type) {
        return type.endsWith("__");
    }

    public CProgramScope withFunctionScope(String pFunctionName) {
        return new CProgramScope(this, pFunctionName, this.locationDescriptor);
    }

    public CProgramScope withLocationDescriptor(Predicate<FileLocation> pLocationDescriptor) {
        return new CProgramScope(this, this.functionName, pLocationDescriptor);
    }

    public String getCurrentFunctionName() {
        Preconditions.checkState((!this.isGlobalScope() ? 1 : 0) != 0);
        return this.functionName;
    }

    private static boolean equals(CType pA, CType pB) {
        return CProgramScope.equals(pA, pB, new HashSet<Pair<CType, CType>>());
    }

    private static boolean equals(@Nullable CType pA, @Nullable CType pB, Set<Pair<CType, CType>> pResolved) {
        if (pA == pB) {
            return true;
        }
        if (pA == null) {
            return false;
        }
        Pair<CType, CType> ab = Pair.of(pA, pB);
        if (pResolved.contains(ab)) {
            return true;
        }
        boolean nonRecEq = pA.equals(pB);
        if (!nonRecEq) {
            return false;
        }
        if (!(pA instanceof CCompositeType)) {
            pResolved.add(ab);
            return true;
        }
        CCompositeType aComp = (CCompositeType)pA;
        CCompositeType bComp = (CCompositeType)pB;
        if (aComp.getMembers().size() != bComp.getMembers().size()) {
            return false;
        }
        pResolved.add(ab);
        Iterator<CCompositeType.CCompositeTypeMemberDeclaration> aMembers = aComp.getMembers().iterator();
        for (CCompositeType.CCompositeTypeMemberDeclaration bMember : bComp.getMembers()) {
            if (CProgramScope.equals(aMembers.next().getType(), bMember.getType(), pResolved)) continue;
            pResolved.remove(ab);
            return false;
        }
        return true;
    }

    private static Multimap<String, CSimpleDeclaration> extractQualifiedDeclarations(FluentIterable<CSimpleDeclaration> pNonFunctionDcls) {
        ImmutableListMultimap qualifiedDeclarationsMultiMap = pNonFunctionDcls.index(CProgramScope::getOriginalQualifiedName);
        return Multimaps.transformValues((Multimap)qualifiedDeclarationsMultiMap, v -> {
            if (v instanceof CVariableDeclaration) {
                CVariableDeclaration original = (CVariableDeclaration)v;
                if (original.getInitializer() == null) {
                    return v;
                }
                return new CVariableDeclaration(original.getFileLocation(), original.isGlobal(), original.getCStorageClass(), original.getType(), original.getName(), original.getOrigName(), original.getQualifiedName(), null);
            }
            return v;
        });
    }

    private static Map<String, CComplexType> extractTypes(FluentIterable<? extends CSimpleDeclaration> pDcls, LogManager pLogger) {
        TypeCollector typeCollector = new TypeCollector();
        for (CSimpleDeclaration declaration : pDcls) {
            declaration.getType().accept(typeCollector);
        }
        ImmutableListMultimap typesMap = FluentIterable.from(typeCollector.getCollectedTypes()).filter(CComplexType.class).index(CComplexType::getQualifiedName);
        HashMap uniqueTypes = new HashMap();
        for (Map.Entry typeEntry : typesMap.asMap().entrySet()) {
            String qualifiedName = (String)typeEntry.getKey();
            Collection types = (Collection)typeEntry.getValue();
            CProgramScope.putIfUnique(uniqueTypes, qualifiedName, types, pLogger);
        }
        return Collections.unmodifiableMap(uniqueTypes);
    }

    private static Map<String, CType> extractTypeDefs(FluentIterable<CTypeDeclaration> pTypeDcls, LogManager pLogger) {
        FluentIterable plainTypeDefs = pTypeDcls.filter(CTypeDefDeclaration.class);
        ImmutableListMultimap typeDefDeclarationsMap = plainTypeDefs.index(CTypeDeclaration::getQualifiedName);
        HashMap uniqueTypeDefs = new HashMap();
        for (Map.Entry typeDefEntry : typeDefDeclarationsMap.asMap().entrySet()) {
            String qualifiedName = (String)typeDefEntry.getKey();
            FluentIterable types = FluentIterable.from((Iterable)((Iterable)typeDefEntry.getValue())).transform(CTypeDeclaration::getType);
            CProgramScope.putIfUnique(uniqueTypeDefs, qualifiedName, types, pLogger);
        }
        return Collections.unmodifiableMap(uniqueTypeDefs);
    }

    private static Multimap<String, CSimpleDeclaration> extractSimpleDeclarations(Multimap<String, CSimpleDeclaration> pQualifiedDeclarations) {
        return Multimaps.index((Iterable)pQualifiedDeclarations.values(), CProgramScope::getName);
    }

    private static Iterable<AAstNode> getAstNodesFromCfaEdge(CFAEdge pEdge) {
        ADeclarationEdge declarationEdge;
        ADeclaration declaration;
        Object nodes = FluentIterable.from(CFAUtils.getAstNodesFromCfaEdge(pEdge)).transformAndConcat(CFAUtils::traverseRecursively);
        if (pEdge instanceof ADeclarationEdge && (declaration = (declarationEdge = (ADeclarationEdge)pEdge).getDeclaration()) instanceof AFunctionDeclaration) {
            nodes = Iterables.concat((Iterable)nodes, ((AFunctionDeclaration)declaration).getParameters());
        }
        return nodes;
    }

    private static Multimap<CAstNode, FileLocation> extractVarUseLocations(Collection<CFANode> pNodes) {
        FluentIterable varUses = FluentIterable.from(pNodes).transformAndConcat(CFAUtils::leavingEdges).transformAndConcat(CProgramScope::getAstNodesFromCfaEdge).filter(CAstNode.class).filter(astNode -> astNode instanceof CIdExpression || astNode instanceof CSimpleDeclaration).filter(astNode -> {
            if (astNode instanceof CIdExpression) {
                return ((CIdExpression)astNode).getDeclaration() != null;
            }
            return true;
        });
        return (Multimap)varUses.stream().collect(ImmutableSetMultimap.toImmutableSetMultimap(astNode -> {
            if (astNode instanceof CSimpleDeclaration) {
                CVariableDeclaration original;
                CSimpleDeclaration decl = (CSimpleDeclaration)astNode;
                if (decl instanceof CVariableDeclaration && (original = (CVariableDeclaration)decl).getInitializer() != null) {
                    return new CVariableDeclaration(original.getFileLocation(), original.isGlobal(), original.getCStorageClass(), original.getType(), original.getName(), original.getOrigName(), original.getQualifiedName(), null);
                }
                return decl;
            }
            CIdExpression idExpression = (CIdExpression)astNode;
            return idExpression.getDeclaration();
        }, astNode -> astNode.getFileLocation()));
    }

    private static <T extends CType> void putIfUnique(Map<String, ? super T> pTarget, String pQualifiedName, Iterable<? extends T> pValues, LogManager pLogger) {
        if (!Iterables.isEmpty(pValues)) {
            Iterator<T> typeIterator = pValues.iterator();
            CType firstType = (CType)typeIterator.next();
            CType firstChecktype = CProgramScope.resolveElaboratedTypeForEqualityCheck(firstType);
            boolean duplicateFound = false;
            while (typeIterator.hasNext() && !duplicateFound) {
                if (CProgramScope.equals(firstChecktype, CProgramScope.resolveElaboratedTypeForEqualityCheck((CType)typeIterator.next()))) continue;
                pLogger.log(Level.FINEST, new Object[]{"Ignoring declaration for", pQualifiedName, " for creation of program-wide scope because it is not unique."});
                duplicateFound = true;
            }
            if (!duplicateFound) {
                for (CType type : pValues) {
                    if (!(type instanceof CElaboratedType)) continue;
                    pTarget.put(pQualifiedName, type);
                    return;
                }
                pTarget.put(pQualifiedName, firstType);
            }
        }
    }

    private static CType resolveElaboratedTypeForEqualityCheck(CType pType) {
        CType currentType = pType;
        while (currentType instanceof CElaboratedType) {
            currentType = ((CElaboratedType)currentType).getRealType();
        }
        return currentType;
    }

    private static <T> T lookupQualifiedComplexType(String pName, Map<String, T> pStorage) {
        HashSet<T> potentialResults = new HashSet<T>();
        for (CComplexType.ComplexTypeKind kind : CComplexType.ComplexTypeKind.values()) {
            T potentialResult = pStorage.get(kind.toASTString() + " " + pName);
            if (potentialResult == null) continue;
            potentialResults.add(potentialResult);
        }
        if (potentialResults.size() == 1) {
            return (T)potentialResults.iterator().next();
        }
        return null;
    }

    public boolean hasFunctionReturnVariable(String pFunctionName) {
        return this.retValDeclarations.containsKey(pFunctionName);
    }

    public CSimpleDeclaration getFunctionReturnVariable(String pFunctionName) {
        CSimpleDeclaration result = this.retValDeclarations.get(pFunctionName);
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (String)"Function unknown or does not have a return value: %s", (Object)pFunctionName);
        return result;
    }

    private static CSimpleDeclaration getArtificialFunctionReturnVariable(CFunctionDeclaration pFunctionDeclaration) {
        String name = ARTIFICIAL_RETVAL_NAME + pFunctionDeclaration.getName() + "__";
        return new CVariableDeclaration(pFunctionDeclaration.getFileLocation(), false, CStorageClass.AUTO, pFunctionDeclaration.getType().getReturnType(), name, name, CProgramScope.createScopedNameOf(pFunctionDeclaration.getName(), name), null);
    }

    public static boolean isArtificialFunctionReturnVariable(CIdExpression pCIdExpression) {
        if (pCIdExpression.getDeclaration() == null) {
            return false;
        }
        String name = pCIdExpression.getDeclaration().getName();
        if (!name.startsWith(ARTIFICIAL_RETVAL_NAME)) {
            return false;
        }
        String qualifiedName = pCIdExpression.getDeclaration().getQualifiedName();
        List parts = Splitter.on((String)"::").splitToList((CharSequence)qualifiedName);
        if (parts.size() < 2) {
            return false;
        }
        return ((String)parts.get(1)).equals(ARTIFICIAL_RETVAL_NAME + (String)parts.get(0) + "__");
    }

    public static String getFunctionNameOfArtificialReturnVar(CIdExpression pCIdExpression) {
        Preconditions.checkArgument((boolean)CProgramScope.isArtificialFunctionReturnVariable(pCIdExpression), (Object)"Variable is not an artificial return variable.");
        String qualifiedName = pCIdExpression.getDeclaration().getQualifiedName();
        return qualifiedName.substring(0, qualifiedName.indexOf("::"));
    }

    private /* synthetic */ Iterable lambda$lookupVariable$5(Supplier s) {
        return FluentIterable.from((Iterable)((Iterable)s.get())).filter(d -> this.uses.get(d).stream().anyMatch(this.locationDescriptor));
    }

    private static class TypeCollector
    extends DefaultCTypeVisitor<Void, NoException> {
        private final Set<CType> collectedTypes;

        public TypeCollector() {
            this(new HashSet<CType>());
        }

        public TypeCollector(Set<CType> pCollectedTypes) {
            this.collectedTypes = pCollectedTypes;
        }

        public Set<CType> getCollectedTypes() {
            return Collections.unmodifiableSet(this.collectedTypes);
        }

        @Override
        public @Nullable Void visitDefault(CType pT) {
            this.collectedTypes.add(pT);
            return null;
        }

        @Override
        public @Nullable Void visit(CArrayType pArrayType) {
            if (this.collectedTypes.add(pArrayType)) {
                pArrayType.getType().accept(this);
                if (pArrayType.getLength() != null) {
                    pArrayType.getLength().getExpressionType().accept(this);
                }
            }
            return null;
        }

        @Override
        public @Nullable Void visit(CCompositeType pCompositeType) {
            if (this.collectedTypes.add(pCompositeType)) {
                for (CCompositeType.CCompositeTypeMemberDeclaration member : pCompositeType.getMembers()) {
                    member.getType().accept(this);
                }
            }
            return null;
        }

        @Override
        public @Nullable Void visit(CElaboratedType pElaboratedType) {
            if (this.collectedTypes.add(pElaboratedType) && pElaboratedType.getRealType() != null) {
                pElaboratedType.getRealType().accept(this);
            }
            return null;
        }

        @Override
        public @Nullable Void visit(CFunctionType pFunctionType) {
            if (this.collectedTypes.add(pFunctionType)) {
                for (CType parameterType : pFunctionType.getParameters()) {
                    parameterType.accept(this);
                }
            }
            return null;
        }

        @Override
        public @Nullable Void visit(CPointerType pPointerType) {
            if (this.collectedTypes.add(pPointerType)) {
                pPointerType.getType().accept(this);
            }
            return null;
        }

        @Override
        public @Nullable Void visit(CTypedefType pTypedefType) {
            if (this.collectedTypes.add(pTypedefType)) {
                pTypedefType.getRealType().accept(this);
            }
            return null;
        }

        @Override
        public @Nullable Void visit(CBitFieldType pCBitFieldType) {
            if (this.collectedTypes.add(pCBitFieldType)) {
                pCBitFieldType.getType().accept(this);
            }
            return null;
        }
    }
}

