/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class CSourceOriginMapping {
    private final Map<Path, RangeMap<Integer, CodePosition>> mapping = new HashMap<Path, RangeMap<Integer, CodePosition>>();

    void mapInputLineRangeToDelta(Path pAnalysisFileName, Path pOriginFileName, int pFromAnalysisCodeLineNumber, int pToAnalysisCodeLineNumber, int pLineDeltaToOrigin) {
        TreeRangeMap fileMapping = this.mapping.get(pAnalysisFileName);
        if (fileMapping == null) {
            fileMapping = TreeRangeMap.create();
            this.mapping.put(pAnalysisFileName, (RangeMap<Integer, CodePosition>)fileMapping);
        }
        Range lineRange = Range.closedOpen((Comparable)Integer.valueOf(pFromAnalysisCodeLineNumber), (Comparable)Integer.valueOf(pToAnalysisCodeLineNumber));
        fileMapping.put(lineRange, (Object)CodePosition.of(pOriginFileName, pLineDeltaToOrigin));
    }

    public CodePosition getOriginLineFromAnalysisCodeLine(Path pAnalysisFileName, int pAnalysisCodeLine) {
        CodePosition originFileAndLineDelta;
        RangeMap<Integer, CodePosition> fileMapping = this.mapping.get(pAnalysisFileName);
        if (fileMapping != null && (originFileAndLineDelta = (CodePosition)fileMapping.get((Comparable)Integer.valueOf(pAnalysisCodeLine))) != null) {
            return originFileAndLineDelta.addToLineNumber(pAnalysisCodeLine);
        }
        return CodePosition.of(pAnalysisFileName, pAnalysisCodeLine);
    }

    public boolean isMappingToIdenticalLineNumbers() {
        return this.mapping.isEmpty();
    }

    public static class CodePosition {
        private final Path fileName;
        private final int lineNumber;

        private CodePosition(Path pFileName, int pLineNumber) {
            this.fileName = pFileName;
            this.lineNumber = pLineNumber;
        }

        public Path getFileName() {
            return this.fileName;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public boolean equals(Object pObj) {
            if (this == pObj) {
                return true;
            }
            if (pObj instanceof CodePosition) {
                CodePosition other = (CodePosition)pObj;
                return this.lineNumber == other.lineNumber && this.fileName.equals(other.fileName);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.fileName, this.lineNumber);
        }

        public CodePosition withFileName(Path pFileName) {
            return CodePosition.of(pFileName, this.lineNumber);
        }

        public CodePosition addToLineNumber(int pDelta) {
            return CodePosition.of(this.fileName, this.lineNumber + pDelta);
        }

        public static CodePosition of(Path pFileName, int pLineNumber) {
            return new CodePosition(pFileName, pLineNumber);
        }
    }
}

