/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.NetworkBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.graph.ForwardingMutableNetwork;

public class CfaMutableNetwork
extends ForwardingMutableNetwork<CFANode, CFAEdge> {
    private CfaMutableNetwork(MutableNetwork<CFANode, CFAEdge> pDelegate) {
        super(pDelegate);
    }

    public static CfaMutableNetwork of(CFA pCfa) {
        MutableNetwork mutableNetwork = NetworkBuilder.directed().allowsSelfLoops(true).build();
        for (CFANode cfaNode : pCfa.getAllNodes()) {
            mutableNetwork.addNode((Object)cfaNode);
            if (!(cfaNode instanceof FunctionEntryNode)) continue;
            FunctionExitNode functionExitNode = ((FunctionEntryNode)cfaNode).getExitNode();
            mutableNetwork.addNode((Object)functionExitNode);
        }
        for (CFANode predecessor : pCfa.getAllNodes()) {
            for (CFAEdge cfaEdge : CFAUtils.allLeavingEdges(predecessor)) {
                CFANode successor = cfaEdge.getSuccessor();
                boolean edgeAdded = mutableNetwork.addEdge((Object)predecessor, (Object)successor, (Object)cfaEdge);
                Preconditions.checkArgument((boolean)edgeAdded, (Object)"CFA must not contain parallel edges");
            }
        }
        return new CfaMutableNetwork((MutableNetwork<CFANode, CFAEdge>)mutableNetwork);
    }

    public void insertPredecessor(CFANode pNewPredecessor, CFANode pNode, CFAEdge pNewInEdge) {
        ImmutableList nodeInEdges = ImmutableList.copyOf(this.inEdges(pNode));
        ArrayList<CFANode> nodeUs = new ArrayList<CFANode>(nodeInEdges.size());
        for (CFAEdge nodeInEdge : nodeInEdges) {
            nodeUs.add((CFANode)this.incidentNodes(nodeInEdge).nodeU());
            this.removeEdge(nodeInEdge);
        }
        this.addNode(pNewPredecessor);
        for (int index = 0; index < nodeInEdges.size(); ++index) {
            this.addEdge((CFANode)nodeUs.get(index), pNewPredecessor, (CFAEdge)nodeInEdges.get(index));
        }
        this.addEdge(pNewPredecessor, pNode, pNewInEdge);
    }

    public void insertSuccessor(CFANode pNode, CFANode pNewSuccessor, CFAEdge pNewOutEdge) {
        ImmutableList nodeOutEdges = ImmutableList.copyOf(this.outEdges(pNode));
        ArrayList<CFANode> nodeVs = new ArrayList<CFANode>(nodeOutEdges.size());
        for (CFAEdge nodeOutEdge : nodeOutEdges) {
            nodeVs.add((CFANode)this.incidentNodes(nodeOutEdge).nodeV());
            this.removeEdge(nodeOutEdge);
        }
        this.addNode(pNewSuccessor);
        for (int index = 0; index < nodeOutEdges.size(); ++index) {
            this.addEdge(pNewSuccessor, (CFANode)nodeVs.get(index), (CFAEdge)nodeOutEdges.get(index));
        }
        this.addEdge(pNode, pNewSuccessor, pNewOutEdge);
    }

    public void replace(CFANode pNode, CFANode pNewNode) {
        this.addNode(pNewNode);
        for (CFAEdge inEdge : ImmutableList.copyOf(this.inEdges(pNode))) {
            CFANode nodeU = (CFANode)this.incidentNodes(inEdge).nodeU();
            this.removeEdge(inEdge);
            this.addEdge(nodeU, pNewNode, inEdge);
        }
        for (CFAEdge outEdge : ImmutableList.copyOf(this.outEdges(pNode))) {
            CFANode nodeV = (CFANode)this.incidentNodes(outEdge).nodeV();
            this.removeEdge(outEdge);
            this.addEdge(pNewNode, nodeV, outEdge);
        }
        this.removeNode(pNode);
    }

    @SuppressFBWarnings(value={"UC_USELESS_VOID_METHOD"})
    public void replace(CFAEdge pEdge, CFAEdge pNewEdge) {
        EndpointPair endpoints = this.incidentNodes(pEdge);
        this.removeEdge(pEdge);
        this.addEdge((CFANode)endpoints.nodeU(), (CFANode)endpoints.nodeV(), pNewEdge);
    }
}

