/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.LiveVariables;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassification;

class ImmutableCFA
implements CFA,
Serializable {
    private static final long serialVersionUID = 5399965350156780812L;
    private final MachineModel machineModel;
    private final ImmutableSortedMap<String, FunctionEntryNode> functions;
    private final ImmutableSortedSet<CFANode> allNodes;
    private final FunctionEntryNode mainFunction;
    private final @Nullable LoopStructure loopStructure;
    private final @Nullable VariableClassification varClassification;
    private final @Nullable LiveVariables liveVariables;
    private final Language language;
    private transient ImmutableList<Path> fileNames;

    ImmutableCFA(MachineModel pMachineModel, Map<String, FunctionEntryNode> pFunctions, SetMultimap<String, CFANode> pAllNodes, FunctionEntryNode pMainFunction, Optional<LoopStructure> pLoopStructure, Optional<VariableClassification> pVarClassification, Optional<LiveVariables> pLiveVariables, List<Path> pFileNames, Language pLanguage) {
        this.machineModel = pMachineModel;
        this.functions = ImmutableSortedMap.copyOf(pFunctions);
        this.allNodes = ImmutableSortedSet.copyOf((Collection)pAllNodes.values());
        this.mainFunction = (FunctionEntryNode)Preconditions.checkNotNull((Object)pMainFunction);
        this.loopStructure = pLoopStructure.orElse(null);
        this.varClassification = pVarClassification.orElse(null);
        this.liveVariables = pLiveVariables.orElse(null);
        this.fileNames = ImmutableList.copyOf(pFileNames);
        this.language = pLanguage;
        Preconditions.checkArgument((boolean)this.mainFunction.equals(this.functions.get((Object)this.mainFunction.getFunctionName())));
    }

    private ImmutableCFA(MachineModel pMachineModel, Language pLanguage) {
        this.machineModel = pMachineModel;
        this.functions = ImmutableSortedMap.of();
        this.allNodes = ImmutableSortedSet.of();
        this.mainFunction = null;
        this.loopStructure = null;
        this.varClassification = null;
        this.liveVariables = null;
        this.fileNames = ImmutableList.of();
        this.language = pLanguage;
    }

    static ImmutableCFA empty(MachineModel pMachineModel, Language pLanguage) {
        return new ImmutableCFA(pMachineModel, pLanguage);
    }

    @Override
    public MachineModel getMachineModel() {
        return this.machineModel;
    }

    @Override
    public boolean isEmpty() {
        return this.functions.isEmpty();
    }

    @Override
    public int getNumberOfFunctions() {
        return this.functions.size();
    }

    public ImmutableSortedSet<String> getAllFunctionNames() {
        return this.functions.keySet();
    }

    public ImmutableCollection<FunctionEntryNode> getAllFunctionHeads() {
        return this.functions.values();
    }

    @Override
    public FunctionEntryNode getFunctionHead(String name) {
        return (FunctionEntryNode)this.functions.get((Object)name);
    }

    public ImmutableSortedMap<String, FunctionEntryNode> getAllFunctions() {
        return this.functions;
    }

    public ImmutableSortedSet<CFANode> getAllNodes() {
        return this.allNodes;
    }

    @Override
    public FunctionEntryNode getMainFunction() {
        return this.mainFunction;
    }

    @Override
    public Optional<LoopStructure> getLoopStructure() {
        return Optional.ofNullable(this.loopStructure);
    }

    @Override
    public Optional<ImmutableSet<CFANode>> getAllLoopHeads() {
        if (this.loopStructure != null) {
            return Optional.of(this.loopStructure.getAllLoopHeads());
        }
        return Optional.empty();
    }

    @Override
    public Optional<VariableClassification> getVarClassification() {
        return Optional.ofNullable(this.varClassification);
    }

    @Override
    public Optional<LiveVariables> getLiveVariables() {
        return Optional.ofNullable(this.liveVariables);
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    @Override
    public List<Path> getFileNames() {
        return this.fileNames;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        ArrayList enteringEdges = new ArrayList();
        for (CFANode node : this.allNodes) {
            Iterables.addAll(enteringEdges, CFAUtils.enteringEdges(node));
        }
        s.writeObject(enteringEdges);
        ArrayList leavingEdges = new ArrayList();
        for (CFANode node : this.allNodes) {
            Iterables.addAll(leavingEdges, CFAUtils.leavingEdges(node));
        }
        s.writeObject(leavingEdges);
        s.writeObject(ImmutableList.copyOf((Collection)Lists.transform(this.fileNames, Path::toString)));
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        for (CFAEdge edge : (List)s.readObject()) {
            edge.getSuccessor().addEnteringEdge(edge);
        }
        for (CFAEdge edge : (List)s.readObject()) {
            edge.getPredecessor().addLeavingEdge(edge);
        }
        this.fileNames = ImmutableList.copyOf((Collection)Lists.transform((List)((List)s.readObject()), x$0 -> Path.of(x$0, new String[0])));
    }
}

