/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.TempFile;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ClangPreprocessor;
import org.sosy_lab.cpachecker.cfa.ParseResult;
import org.sosy_lab.cpachecker.cfa.parser.llvm.LlvmParser;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.exceptions.ClangParserException;
import org.sosy_lab.cpachecker.exceptions.ParserException;

public class LlvmParserWithClang
extends LlvmParser {
    private final ClangPreprocessor preprocessor;

    public LlvmParserWithClang(ClangPreprocessor pPreprocessor, LogManager pLogger, MachineModel pMachineModel) {
        super(pLogger, pMachineModel);
        this.preprocessor = pPreprocessor;
    }

    @Override
    public ParseResult parseFiles(List<String> pFilenames) throws ParserException, InterruptedException, InvalidConfigurationException {
        if (pFilenames.size() > 1) {
            throw new InvalidConfigurationException("Multiple program files not supported when using LLVM frontend.");
        }
        Path filename = Path.of(pFilenames.get(0), new String[0]);
        return this.parseSingleFile(filename);
    }

    @Override
    public ParseResult parseString(Path pFilename, String pCode) throws ParserException, InterruptedException {
        ParseResult parseResult;
        block8: {
            Objects.requireNonNull(pFilename);
            TempFile.DeleteOnCloseDir tempDir = TempFile.createDeleteOnCloseDir((String)"input-for-llvm-with-clang", (FileAttribute[])new FileAttribute[0]);
            try {
                Path tempFile = tempDir.toPath().resolve(pFilename).normalize();
                IO.writeFile((Path)tempFile, (Charset)Charset.defaultCharset(), (Object)pCode);
                parseResult = this.parseSingleFile(tempFile);
                if (tempDir == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tempDir != null) {
                        try {
                            tempDir.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ClangParserException("Could not write clang input to file " + e.getMessage(), e);
                }
            }
            tempDir.close();
        }
        return parseResult;
    }

    private ParseResult parseSingleFile(Path pFilename) throws ParserException, InterruptedException {
        ParseResult parseResult;
        block9: {
            if (this.preprocessor.getDumpDirectory() != null) {
                return this.parse0(pFilename, this.preprocessor.getDumpDirectory());
            }
            TempFile.DeleteOnCloseDir tempDir = TempFile.createDeleteOnCloseDir((String)"clang-results", (FileAttribute[])new FileAttribute[0]);
            try {
                parseResult = this.parse0(pFilename, tempDir.toPath());
                if (tempDir == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (tempDir != null) {
                        try {
                            tempDir.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ClangParserException("Could not write clang output to file " + e.getMessage(), e);
                }
            }
            tempDir.close();
        }
        return parseResult;
    }

    private ParseResult parse0(Path pFilename, Path pDumpDirectory) throws ParserException, InterruptedException {
        Path dumpedFile = this.preprocessor.preprocessAndGetDumpedFile(pFilename, pDumpDirectory);
        return super.parseFile(dumpedFile);
    }

    static class Factory {
        Factory() {
        }

        public static LlvmParserWithClang getParser(ClangPreprocessor processor, LogManager logger, MachineModel machine) {
            return new LlvmParserWithClang(processor, logger, machine);
        }
    }
}

