/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ClangPreprocessor;
import org.sosy_lab.cpachecker.cfa.LlvmParserWithClang;
import org.sosy_lab.cpachecker.cfa.ParseResult;
import org.sosy_lab.cpachecker.cfa.parser.llvm.LlvmUtils;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.exceptions.ClangParserException;
import org.sosy_lab.cpachecker.exceptions.ParserException;
import org.sosy_lab.cpachecker.util.test.TestDataTools;

@RunWith(value=Parameterized.class)
public class LlvmParserWithClangTest {
    @Parameterized.Parameter(value=0)
    public Path testFile;
    @Parameterized.Parameter(value=1)
    public Path fileName;
    private LlvmParserWithClang fileParser;
    private LlvmParserWithClang stringParser;

    @Parameterized.Parameters(name="{0} with file name {1}")
    public static List<Object[]> testcases() {
        ImmutableList testFiles = ImmutableList.of((Object)Path.of("test/programs/llvm/switch-case.c", new String[0]), (Object)Path.of("test/programs/simple/globalVariableInitialValue-1.c", new String[0]));
        ImmutableList fileNames = ImmutableList.of((Object)Path.of("test.c", new String[0]), (Object)Path.of("test", new String[0]));
        List testcases = Lists.cartesianProduct((List[])new List[]{testFiles, fileNames});
        return (List)testcases.stream().map(List::toArray).collect(ImmutableList.toImmutableList());
    }

    @Before
    public void createParsers() throws InvalidConfigurationException {
        Configuration config = TestDataTools.configurationForTest().build();
        LogManager logger = LogManager.createTestLogManager();
        ClangPreprocessor clangPreprocessor = new ClangPreprocessor(config, logger);
        this.stringParser = LlvmParserWithClang.Factory.getParser(clangPreprocessor, logger, MachineModel.LINUX32);
        this.fileParser = LlvmParserWithClang.Factory.getParser(clangPreprocessor, logger, MachineModel.LINUX32);
    }

    @Test
    public void testStringParseResultEqualsFileParseResult() throws ParserException, InterruptedException, InvalidConfigurationException, IOException {
        ParseResult fileResult;
        String code = Files.readString(this.testFile, Charset.defaultCharset());
        try {
            fileResult = this.fileParser.parseFiles((List<String>)ImmutableList.of((Object)this.testFile.toString()));
        }
        catch (ClangParserException e) {
            TruthJUnit.assume().that((Throwable)e).hasMessageThat().doesNotContain((CharSequence)("Clang failed: Cannot run program \"clang-" + LlvmUtils.extractVersionNumberFromLlvmJ() + "\": error=2"));
            throw e;
        }
        ParseResult stringResult = this.stringParser.parseString(this.fileName, code);
        Truth.assertThat((Boolean)stringResult.isEmpty()).isEqualTo((Object)fileResult.isEmpty());
        Truth.assertThat(stringResult.getCFANodes()).hasSize(fileResult.getCFANodes().size());
        Truth.assertThat(stringResult.getFunctions().keySet()).containsExactlyElementsIn(fileResult.getFunctions().keySet());
        for (String function : stringResult.getFunctions().keySet()) {
            Truth.assertThat((Iterable)stringResult.getCFANodes().get((Object)function)).hasSize(fileResult.getCFANodes().get((Object)function).size());
        }
        Truth.assertThat(stringResult.getGlobalDeclarations()).isEqualTo(fileResult.getGlobalDeclarations());
    }
}

