/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.TreeMultimap;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ImmutableCFA;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.util.LiveVariables;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassification;

public class MutableCFA
implements CFA {
    private final MachineModel machineModel;
    private final NavigableMap<String, FunctionEntryNode> functions;
    private final TreeMultimap<String, CFANode> allNodes;
    private final FunctionEntryNode mainFunction;
    private final List<Path> fileNames;
    private final Language language;
    private Optional<LoopStructure> loopStructure = Optional.empty();
    private Optional<LiveVariables> liveVariables = Optional.empty();

    public MutableCFA(MachineModel pMachineModel, NavigableMap<String, FunctionEntryNode> pFunctions, TreeMultimap<String, CFANode> pAllNodes, FunctionEntryNode pMainFunction, List<Path> pFileNames, Language pLanguage) {
        this.machineModel = pMachineModel;
        this.functions = pFunctions;
        this.allNodes = pAllNodes;
        this.mainFunction = (FunctionEntryNode)Preconditions.checkNotNull((Object)pMainFunction);
        this.fileNames = ImmutableList.copyOf(pFileNames);
        this.language = pLanguage;
        assert (this.functions.keySet().equals(this.allNodes.keySet()));
        assert (this.mainFunction.equals(this.functions.get(this.mainFunction.getFunctionName())));
    }

    public void addNode(CFANode pNode) {
        assert (this.functions.containsKey(pNode.getFunctionName()));
        this.allNodes.put((Object)pNode.getFunctionName(), (Object)pNode);
    }

    public void clear() {
        this.functions.clear();
        this.allNodes.clear();
    }

    public void removeNode(CFANode pNode) {
        NavigableSet functionNodes = this.allNodes.get((Object)pNode.getFunctionName());
        assert (functionNodes.contains(pNode));
        functionNodes.remove(pNode);
        if (functionNodes.isEmpty()) {
            this.functions.remove(pNode.getFunctionName());
        }
    }

    @Override
    public MachineModel getMachineModel() {
        return this.machineModel;
    }

    @Override
    public boolean isEmpty() {
        return this.functions.isEmpty();
    }

    @Override
    public int getNumberOfFunctions() {
        return this.functions.size();
    }

    @Override
    public NavigableSet<String> getAllFunctionNames() {
        return Collections.unmodifiableNavigableSet(this.functions.navigableKeySet());
    }

    @Override
    public Collection<FunctionEntryNode> getAllFunctionHeads() {
        return Collections.unmodifiableCollection(this.functions.values());
    }

    @Override
    public FunctionEntryNode getFunctionHead(String pName) {
        return (FunctionEntryNode)this.functions.get(pName);
    }

    @Override
    public NavigableMap<String, FunctionEntryNode> getAllFunctions() {
        return Collections.unmodifiableNavigableMap(this.functions);
    }

    public NavigableSet<CFANode> getFunctionNodes(String pName) {
        return Collections.unmodifiableNavigableSet(this.allNodes.get((Object)pName));
    }

    @Override
    public Collection<CFANode> getAllNodes() {
        return Collections.unmodifiableCollection(this.allNodes.values());
    }

    @Override
    public FunctionEntryNode getMainFunction() {
        return this.mainFunction;
    }

    @Override
    public Optional<LoopStructure> getLoopStructure() {
        return this.loopStructure;
    }

    public void setLoopStructure(LoopStructure pLoopStructure) {
        this.loopStructure = Optional.of(pLoopStructure);
    }

    @Override
    public Optional<ImmutableSet<CFANode>> getAllLoopHeads() {
        if (this.loopStructure.isPresent()) {
            return Optional.of(this.loopStructure.orElseThrow().getAllLoopHeads());
        }
        return Optional.empty();
    }

    public ImmutableCFA makeImmutableCFA(Optional<VariableClassification> pVarClassification) {
        return new ImmutableCFA(this.machineModel, (Map<String, FunctionEntryNode>)this.functions, (SetMultimap<String, CFANode>)this.allNodes, this.mainFunction, this.loopStructure, pVarClassification, this.liveVariables, this.fileNames, this.language);
    }

    @Override
    public Optional<VariableClassification> getVarClassification() {
        return Optional.empty();
    }

    @Override
    public Optional<LiveVariables> getLiveVariables() {
        return this.liveVariables;
    }

    public void setLiveVariables(LiveVariables pLiveVariables) {
        this.liveVariables = Optional.of(pLiveVariables);
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    @Override
    public List<Path> getFileNames() {
        return this.fileNames;
    }
}

