/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.TreeMultimap;
import java.nio.file.Path;
import java.util.List;
import java.util.NavigableMap;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.util.Pair;

public class ParseResult {
    private final NavigableMap<String, FunctionEntryNode> functions;
    private final TreeMultimap<String, CFANode> cfaNodes;
    private final List<Pair<ADeclaration, String>> globalDeclarations;
    private final List<Path> fileNames;

    public ParseResult(NavigableMap<String, FunctionEntryNode> pFunctions, TreeMultimap<String, CFANode> pCfaNodes, List<Pair<ADeclaration, String>> pGlobalDeclarations, List<Path> pFileNames) {
        this.functions = pFunctions;
        this.cfaNodes = pCfaNodes;
        this.globalDeclarations = pGlobalDeclarations;
        this.fileNames = ImmutableList.copyOf(pFileNames);
    }

    public boolean isEmpty() {
        return this.functions.isEmpty();
    }

    public NavigableMap<String, FunctionEntryNode> getFunctions() {
        return this.functions;
    }

    public TreeMultimap<String, CFANode> getCFANodes() {
        return this.cfaNodes;
    }

    public List<Pair<ADeclaration, String>> getGlobalDeclarations() {
        return this.globalDeclarations;
    }

    public List<Path> getFileNames() {
        return this.fileNames;
    }
}

