/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.MoreStrings;
import org.sosy_lab.common.ProcessExecutor;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.exceptions.ParserException;

@Options(prefix="parser")
public abstract class Preprocessor {
    @Option(name="preprocessor.dumpDirectory", description="Directory where to dump the results of the preprocessor.")
    @FileOption(value=FileOption.Type.OUTPUT_DIRECTORY)
    private Path dumpDirectory = Path.of("preprocessed", new String[0]);
    protected final LogManager logger;

    protected Preprocessor(Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        config.inject((Object)this, Preprocessor.class);
        this.logger = pLogger;
        if (this.dumpDirectory != null) {
            this.dumpDirectory = this.dumpDirectory.toAbsolutePath().normalize();
        }
    }

    public String preprocess(Path file) throws ParserException, InterruptedException {
        String result = this.preprocess0(file);
        this.getAndWriteDumpFile(result, file);
        return result;
    }

    public Path getDumpDirectory() {
        return this.dumpDirectory;
    }

    protected String preprocess0(Path file) throws ParserException, InterruptedException {
        ArrayList argList = Lists.newArrayList((Iterable)Splitter.on((CharMatcher)CharMatcher.whitespace()).omitEmptyStrings().split((CharSequence)this.getCommandLine()));
        argList.add(file.toString());
        String[] args = argList.toArray(new String[0]);
        this.logger.log(Level.FINE, new Object[]{"Running", MoreStrings.lazyString(this::getName), argList});
        try {
            PreprocessorExecutor executor = new PreprocessorExecutor(this.logger, args);
            executor.sendEOF();
            int exitCode = executor.join();
            this.logger.log(Level.FINE, () -> this.getCapitalizedName() + " finished");
            if (exitCode != 0) {
                throw this.createCorrespondingParserException(this.getCapitalizedName() + " failed with exit code " + exitCode);
            }
            if (executor.errorOutputCount > 0) {
                this.logger.log(Level.WARNING, new Object[]{MoreStrings.lazyString(() -> this.getCapitalizedName() + " returned successfully, but printed warnings/errors. Please check the log above!")});
            }
            if (executor.buffer == null) {
                return "";
            }
            return executor.buffer.toString();
        }
        catch (IOException e) {
            throw this.createCorrespondingParserException(this.getCapitalizedName() + " failed", e);
        }
    }

    protected @Nullable Path getAndWriteDumpFile(String programCode, Path file) {
        return this.getAndWriteDumpFile(programCode, file, this.dumpDirectory);
    }

    protected @Nullable Path getAndWriteDumpFile(String programCode, Path file, Path pDumpDirectory) {
        if (this.dumpResults() && pDumpDirectory != null) {
            Path dumpFile = pDumpDirectory.resolve(this.getDumpFileOfFile(file.toString())).normalize();
            Path tmpDir = Path.of(StandardSystemProperty.JAVA_IO_TMPDIR.value(), new String[0]);
            if (dumpFile.startsWith(pDumpDirectory) || dumpFile.startsWith(tmpDir)) {
                try {
                    IO.writeFile((Path)dumpFile, (Charset)Charset.defaultCharset(), (Object)programCode);
                }
                catch (IOException e) {
                    this.logger.logUserException(Level.WARNING, (Throwable)e, "Cannot write result of preprocessing to file");
                }
            } else {
                this.logger.logf(Level.WARNING, "Cannot dump result of preprocessing file %s, because path is outside the current directory and the result would end up outside the output/temporary directory.", new Object[]{file});
            }
            return dumpFile;
        }
        return null;
    }

    protected abstract String getName();

    protected abstract String getCommandLine();

    protected abstract ParserException createCorrespondingParserException(String var1);

    protected abstract ParserException createCorrespondingParserException(String var1, Throwable var2);

    protected abstract boolean dumpResults();

    protected abstract String getDumpFileOfFile(String var1);

    private String getCapitalizedName() {
        return this.getName().substring(0, 1).toUpperCase() + this.getName().substring(1);
    }

    private static class PreprocessorExecutor
    extends ProcessExecutor<IOException> {
        private static final int MAX_ERROR_OUTPUT_SHOWN = 10;
        private static final ImmutableMap<String, String> ENV_VARS = ImmutableMap.of((Object)"LANG", (Object)"C");
        @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="Written only by one thread")
        private volatile int errorOutputCount = 0;
        private volatile StringBuffer buffer;

        public PreprocessorExecutor(LogManager logger, String[] args) throws IOException {
            super(logger, IOException.class, ENV_VARS, args);
        }

        protected void handleErrorOutput(String pLine) throws IOException {
            if (this.errorOutputCount == 10) {
                this.logger.log(Level.WARNING, new Object[]{"Skipping further preprocessor error output..."});
                ++this.errorOutputCount;
            } else if (this.errorOutputCount < 10) {
                ++this.errorOutputCount;
                super.handleErrorOutput(pLine);
            }
        }

        protected void handleOutput(String pLine) {
            if (this.buffer == null) {
                this.buffer = new StringBuffer();
            }
            this.buffer.append(pLine);
            this.buffer.append('\n');
        }

        protected void handleExitCode(int pCode) {
        }
    }
}

