/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AbstractLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.types.Type;

public abstract class AArraySubscriptExpression
extends AbstractLeftHandSide {
    private static final long serialVersionUID = 8359800949073538182L;
    private final AExpression arrayExpression;
    private final AExpression subscriptExpression;

    protected AArraySubscriptExpression(FileLocation pFileLocation, Type pType, AExpression pArrayExpression, AExpression pSubscriptExpression) {
        super(pFileLocation, pType);
        this.arrayExpression = pArrayExpression;
        this.subscriptExpression = pSubscriptExpression;
    }

    public AExpression getArrayExpression() {
        return this.arrayExpression;
    }

    public AExpression getSubscriptExpression() {
        return this.subscriptExpression;
    }

    @Override
    public String toASTString(boolean pQualified) {
        String left = this.arrayExpression instanceof AArraySubscriptExpression ? this.arrayExpression.toASTString(pQualified) : this.arrayExpression.toParenthesizedASTString(pQualified);
        return left + "[" + this.subscriptExpression.toASTString(pQualified) + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.arrayExpression);
        result = 31 * result + Objects.hashCode(this.subscriptExpression);
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AArraySubscriptExpression) || !super.equals(obj)) {
            return false;
        }
        AArraySubscriptExpression other = (AArraySubscriptExpression)obj;
        return Objects.equals(other.arrayExpression, this.arrayExpression) && Objects.equals(other.subscriptExpression, this.subscriptExpression);
    }
}

