/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AbstractExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.types.Type;

public abstract class ABinaryExpression
extends AbstractExpression {
    private static final long serialVersionUID = 516716556428189182L;
    private final AExpression operand1;
    private final AExpression operand2;
    private final ABinaryOperator operator;

    protected ABinaryExpression(FileLocation pFileLocation, Type pType, AExpression pOperand1, AExpression pOperand2, ABinaryOperator pOperator) {
        super(pFileLocation, pType);
        this.operand1 = pOperand1;
        this.operand2 = pOperand2;
        this.operator = pOperator;
    }

    public AExpression getOperand1() {
        return this.operand1;
    }

    public AExpression getOperand2() {
        return this.operand2;
    }

    public ABinaryOperator getOperator() {
        return this.operator;
    }

    @Override
    public String toASTString(boolean pQualified) {
        return this.operand1.toParenthesizedASTString(pQualified) + " " + this.operator.getOperator() + " " + this.operand2.toParenthesizedASTString(pQualified);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.operand1);
        result = 31 * result + Objects.hashCode(this.operand2);
        result = 31 * result + Objects.hashCode(this.operator);
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ABinaryExpression) || !super.equals(obj)) {
            return false;
        }
        ABinaryExpression other = (ABinaryExpression)obj;
        return Objects.equals(other.operand1, this.operand1) && Objects.equals(other.operand2, this.operand2) && Objects.equals(other.operator, this.operator);
    }

    @Override
    public String toString() {
        return "operand1=[" + this.getOperand1() + "], operand2=[" + this.getOperand2() + "], operator=[" + this.getOperator() + "]";
    }

    public static interface ABinaryOperator {
        public String getOperator();
    }
}

