/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AbstractLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.types.Type;

public abstract class ACastExpression
extends AbstractLeftHandSide {
    private static final long serialVersionUID = 7047818239785351507L;
    private final AExpression operand;
    private final Type castType;

    protected ACastExpression(FileLocation pFileLocation, Type castExpressionType, AExpression pOperand) {
        super(pFileLocation, castExpressionType);
        this.operand = pOperand;
        this.castType = castExpressionType;
    }

    public AExpression getOperand() {
        return this.operand;
    }

    @Override
    public String toASTString(boolean pQualified) {
        return "(" + this.getExpressionType().toASTString("") + ")" + this.operand.toParenthesizedASTString(pQualified);
    }

    public Type getCastType() {
        return this.castType;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.castType);
        result = 31 * result + Objects.hashCode(this.operand);
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ACastExpression) || !super.equals(obj)) {
            return false;
        }
        ACastExpression other = (ACastExpression)obj;
        return Objects.equals(other.operand, this.operand) && Objects.equals(other.castType, this.castType);
    }
}

