/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.AAssignment;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.ALeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.AStatementVisitor;
import org.sosy_lab.cpachecker.cfa.ast.AbstractStatement;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;

public abstract class AExpressionAssignmentStatement
extends AbstractStatement
implements AAssignment {
    private static final long serialVersionUID = -6099960243945488221L;
    private final ALeftHandSide leftHandSide;
    private final AExpression rightHandSide;

    protected AExpressionAssignmentStatement(FileLocation pFileLocation, ALeftHandSide pLeftHandSide, AExpression pRightHandSide) {
        super(pFileLocation);
        this.leftHandSide = (ALeftHandSide)Preconditions.checkNotNull((Object)pLeftHandSide);
        this.rightHandSide = (AExpression)Preconditions.checkNotNull((Object)pRightHandSide);
    }

    @Override
    public String toASTString(boolean pQualified) {
        return this.leftHandSide.toASTString(pQualified) + " = " + this.rightHandSide.toASTString(pQualified) + ";";
    }

    @Override
    public ALeftHandSide getLeftHandSide() {
        return this.leftHandSide;
    }

    @Override
    public AExpression getRightHandSide() {
        return this.rightHandSide;
    }

    @Override
    public <R, X extends Exception> R accept(AStatementVisitor<R, X> pV) throws X {
        return pV.visit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.leftHandSide);
        result = 31 * result + Objects.hashCode(this.rightHandSide);
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AExpressionAssignmentStatement) || !super.equals(obj)) {
            return false;
        }
        AExpressionAssignmentStatement other = (AExpressionAssignmentStatement)obj;
        return Objects.equals(other.leftHandSide, this.leftHandSide) && Objects.equals(other.rightHandSide, this.rightHandSide);
    }
}

