/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import java.math.BigDecimal;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.ALiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.types.Type;

public abstract class AFloatLiteralExpression
extends ALiteralExpression {
    private static final long serialVersionUID = 8161363025296340648L;
    private final BigDecimal value;

    protected AFloatLiteralExpression(FileLocation pFileLocation, Type pType, BigDecimal pValue) {
        super(pFileLocation, pType);
        this.value = pValue;
    }

    @Override
    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public String toASTString() {
        if (this.value.scale() <= 0) {
            return String.format("%.1f", this.value);
        }
        return this.value.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.value);
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AFloatLiteralExpression) || !super.equals(obj)) {
            return false;
        }
        AFloatLiteralExpression other = (AFloatLiteralExpression)obj;
        return Objects.equals(other.value, this.value);
    }
}

