/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AbstractLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.types.Type;

public abstract class AIdExpression
extends AbstractLeftHandSide {
    private static final long serialVersionUID = -2534849615394054260L;
    private final String name;
    private final ASimpleDeclaration declaration;

    protected AIdExpression(FileLocation pFileLocation, Type pType, String pName, ASimpleDeclaration pDeclaration) {
        super(pFileLocation, pType);
        this.name = pName.intern();
        this.declaration = pDeclaration;
    }

    protected AIdExpression(FileLocation pFileLocation, ASimpleDeclaration pDeclaration) {
        this(pFileLocation, pDeclaration.getType(), pDeclaration.getName(), pDeclaration);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toParenthesizedASTString(boolean pQualified) {
        return this.toASTString(pQualified);
    }

    @Override
    public String toASTString(boolean pQualified) {
        String qualName;
        ASimpleDeclaration decl;
        if (pQualified && (decl = this.getDeclaration()) != null && (qualName = decl.getQualifiedName()) != null) {
            return qualName.replace("::", "__");
        }
        return this.name;
    }

    public ASimpleDeclaration getDeclaration() {
        return this.declaration;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.declaration);
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AIdExpression) || !super.equals(obj)) {
            return false;
        }
        AIdExpression other = (AIdExpression)obj;
        return Objects.equals(other.declaration, this.declaration) && Objects.equals(other.name, this.name);
    }
}

