/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.ast.AAssignment;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AReturnStatement;
import org.sosy_lab.cpachecker.cfa.ast.AbstractAstNode;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;

public abstract class AbstractReturnStatement
extends AbstractAstNode
implements AReturnStatement {
    private static final long serialVersionUID = 2672685167471010046L;
    private final @Nullable AExpression expression;
    private final @Nullable AAssignment assignment;

    protected AbstractReturnStatement(FileLocation pFileLocation, Optional<? extends AExpression> pExpression, Optional<? extends AAssignment> pAssignment) {
        super(pFileLocation);
        this.expression = pExpression.orElse(null);
        this.assignment = pAssignment.orElse(null);
    }

    @Override
    public String toASTString(boolean pQualified) {
        return "return" + (String)(this.expression != null ? " " + this.expression.toASTString(pQualified) : "") + ";";
    }

    @Override
    public Optional<? extends AExpression> getReturnValue() {
        return Optional.ofNullable(this.expression);
    }

    @Override
    public Optional<? extends AAssignment> asAssignment() {
        return Optional.ofNullable(this.assignment);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.expression);
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractReturnStatement) || !super.equals(obj)) {
            return false;
        }
        AbstractReturnStatement other = (AbstractReturnStatement)obj;
        return Objects.equals(other.expression, this.expression);
    }
}

