/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import com.google.common.base.Strings;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AbstractAstNode;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.types.Type;

public abstract class AbstractSimpleDeclaration
extends AbstractAstNode
implements ASimpleDeclaration {
    private static final long serialVersionUID = 1078153969461542233L;
    private Type type;
    private final String name;
    private final String origName;

    protected AbstractSimpleDeclaration(FileLocation pFileLocation, Type pType, String pName, String pOrigName) {
        super(pFileLocation);
        this.type = pType;
        this.name = pName;
        this.origName = pOrigName;
    }

    protected AbstractSimpleDeclaration(FileLocation pFileLocation, Type pType, String pName) {
        this(pFileLocation, pType, pName, pName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getOrigName() {
        return this.origName;
    }

    @Override
    public String toASTString(boolean pQualified) {
        String nameAsString = pQualified ? Strings.nullToEmpty((String)this.getQualifiedName()).replace("::", "__") : Strings.nullToEmpty((String)this.getName());
        return this.getType().toASTString(nameAsString) + ";";
    }

    @Override
    public Type getType() {
        return this.type;
    }

    protected void setType(Type pType) {
        this.type = pType;
    }

    @Override
    public int hashCode() {
        return 31 * Objects.hash(this.type, this.name, this.origName) + super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractSimpleDeclaration) || !super.equals(obj)) {
            return false;
        }
        AbstractSimpleDeclaration other = (AbstractSimpleDeclaration)obj;
        return Objects.equals(other.type, this.type) && Objects.equals(other.name, this.name) && Objects.equals(other.origName, this.origName);
    }
}

