/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.Immutable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;

@Immutable
public class FileLocation
implements Serializable,
Comparable<FileLocation> {
    private static final long serialVersionUID = 6652099907084949014L;
    private final transient Path fileName;
    private final String niceFileName;
    private final int offset;
    private final int length;
    private final int startingLine;
    private final int endingLine;
    private final int startingLineInOrigin;
    private final int endingLineInOrigin;
    private final boolean offsetRelatedToOrigin;
    public static final FileLocation DUMMY = new FileLocation(Path.of("#none#", new String[0]), 0, 0, 0, 0){
        private static final long serialVersionUID = -3012034075570811723L;

        @Override
        public boolean isRealLocation() {
            return false;
        }

        @Override
        public String toString() {
            return "none";
        }
    };
    public static final FileLocation MULTIPLE_FILES = new FileLocation(Path.of("#multiple files#", new String[0]), 0, 0, 0, 0){
        private static final long serialVersionUID = -1725179775900132985L;

        @Override
        public boolean isRealLocation() {
            return false;
        }

        @Override
        public String toString() {
            return this.getFileName().toString();
        }
    };

    public FileLocation(Path pFileName, int pOffset, int pLength, int pStartingLine, int pEndingLine) {
        this(pFileName, pFileName.toString(), pOffset, pLength, pStartingLine, pEndingLine, pStartingLine, pEndingLine, true);
    }

    public FileLocation(Path pFileName, String pNiceFileName, int pOffset, int pLength, int pStartingLine, int pEndingLine, int pStartingLineInOrigin, int pEndingLineInOrigin, boolean pOffsetRelatedToOrigin) {
        this.fileName = (Path)Preconditions.checkNotNull((Object)pFileName);
        Preconditions.checkArgument((!this.fileName.toString().isEmpty() ? 1 : 0) != 0, (Object)"Non-empty file name required");
        this.niceFileName = (String)Preconditions.checkNotNull((Object)pNiceFileName);
        this.offset = pOffset;
        this.length = pLength;
        this.startingLine = pStartingLine;
        this.endingLine = pEndingLine;
        this.startingLineInOrigin = pStartingLineInOrigin;
        this.endingLineInOrigin = pEndingLineInOrigin;
        this.offsetRelatedToOrigin = pOffsetRelatedToOrigin;
    }

    public static FileLocation merge(List<FileLocation> locations) {
        Preconditions.checkArgument((!Iterables.isEmpty(locations) ? 1 : 0) != 0);
        Path fileName = null;
        String niceFileName = null;
        int startingLine = Integer.MAX_VALUE;
        int startingLineInOrigin = Integer.MAX_VALUE;
        int startOffset = Integer.MAX_VALUE;
        int endingLine = Integer.MIN_VALUE;
        int endingLineInOrigin = Integer.MIN_VALUE;
        int endOffset = Integer.MIN_VALUE;
        boolean offsetRelatedToOrigin = true;
        for (FileLocation loc : locations) {
            if (DUMMY.equals(loc)) continue;
            if (fileName == null) {
                fileName = loc.fileName;
                niceFileName = loc.niceFileName;
            } else if (!fileName.equals(loc.fileName)) {
                return MULTIPLE_FILES;
            }
            startingLine = Math.min(startingLine, loc.getStartingLineNumber());
            startingLineInOrigin = Math.min(startingLineInOrigin, loc.getStartingLineInOrigin());
            startOffset = Math.min(startOffset, loc.getNodeOffset());
            endingLine = Math.max(endingLine, loc.getEndingLineNumber());
            endingLineInOrigin = Math.max(endingLineInOrigin, loc.getEndingLineInOrigin());
            endOffset = Math.max(endOffset, loc.getNodeOffset() + loc.getNodeLength());
            offsetRelatedToOrigin &= loc.offsetRelatedToOrigin;
        }
        if (fileName == null) {
            return DUMMY;
        }
        return new FileLocation(fileName, niceFileName, startOffset, endOffset - startOffset, startingLine, endingLine, startingLineInOrigin, endingLineInOrigin, offsetRelatedToOrigin);
    }

    public boolean isRealLocation() {
        return true;
    }

    public Path getFileName() {
        return this.fileName;
    }

    public String getNiceFileName() {
        return this.niceFileName;
    }

    public int getNodeOffset() {
        return this.offset;
    }

    public int getNodeLength() {
        return this.length;
    }

    public int getStartingLineNumber() {
        return this.startingLine;
    }

    public int getEndingLineNumber() {
        return this.endingLine;
    }

    public int getStartingLineInOrigin() {
        return this.startingLineInOrigin;
    }

    public int getEndingLineInOrigin() {
        return this.endingLineInOrigin;
    }

    public boolean isOffsetRelatedToOrigin() {
        return this.offsetRelatedToOrigin;
    }

    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.fileName);
        result = 31 * result + this.offset;
        result = 31 * result + this.length;
        result = 31 * result + this.startingLine;
        result = 31 * result + this.endingLine;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FileLocation)) {
            return false;
        }
        FileLocation other = (FileLocation)obj;
        return other.offset == this.offset && other.length == this.length && other.startingLine == this.startingLine && other.endingLine == this.endingLine && Objects.equals(other.fileName, this.fileName);
    }

    @Override
    public int compareTo(FileLocation pOther) {
        return ComparisonChain.start().compare((Comparable)this.fileName, (Comparable)pOther.fileName).compare(this.offset, pOther.offset).compare(this.length, pOther.length).result();
    }

    public String toString() {
        String prefix;
        String string = prefix = this.niceFileName.isEmpty() ? "" : this.niceFileName + ", ";
        if (this.startingLineInOrigin == this.endingLineInOrigin) {
            return prefix + "line " + this.startingLineInOrigin;
        }
        return prefix + "lines " + this.startingLineInOrigin + "-" + this.endingLineInOrigin;
    }

    protected Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        throw new InvalidObjectException("Proxy required");
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = -3730421630343690695L;
        private final String fileName;
        private final String niceFileName;
        private final int offset;
        private final int length;
        private final int startingLine;
        private final int endingLine;
        private final int startingLineInOrigin;
        private final int endingLineInOrigin;
        private final boolean offsetRelatedToOrigin;

        SerializationProxy(FileLocation loc) {
            this.fileName = loc.fileName.toString();
            this.niceFileName = loc.niceFileName;
            this.offset = loc.offset;
            this.length = loc.length;
            this.startingLine = loc.startingLine;
            this.endingLine = loc.endingLine;
            this.startingLineInOrigin = loc.startingLineInOrigin;
            this.endingLineInOrigin = loc.endingLineInOrigin;
            this.offsetRelatedToOrigin = loc.offsetRelatedToOrigin;
        }

        private Object readResolve() {
            FileLocation result = new FileLocation(Path.of(this.fileName, new String[0]), this.niceFileName, this.offset, this.length, this.startingLine, this.endingLine, this.startingLineInOrigin, this.endingLineInOrigin, this.offsetRelatedToOrigin);
            if (result.equals(DUMMY)) {
                return DUMMY;
            }
            if (result.equals(MULTIPLE_FILES)) {
                return MULTIPLE_FILES;
            }
            return result;
        }
    }
}

