/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.acsl;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLAnnotation;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLPredicate;
import org.sosy_lab.cpachecker.cfa.ast.acsl.Behavior;

public class ACSLAssertion
implements ACSLAnnotation {
    private final AssertionKind kind;
    private final ImmutableList<Behavior> enclosingBehaviors;
    private final ACSLPredicate predicate;

    ACSLAssertion(AssertionKind pKind, ACSLPredicate p) {
        this(pKind, (List<Behavior>)ImmutableList.of(), p);
    }

    ACSLAssertion(AssertionKind pKind, List<Behavior> enclosing, ACSLPredicate p) {
        this.kind = pKind;
        this.enclosingBehaviors = ImmutableList.copyOf(enclosing);
        this.predicate = p.simplify();
    }

    @Override
    public List<Behavior> getDeclaredBehaviors() {
        return ImmutableList.of();
    }

    @Override
    public List<Behavior> getReferencedBehaviors() {
        return this.enclosingBehaviors;
    }

    @Override
    public ACSLPredicate getPredicateRepresentation() {
        if (!this.enclosingBehaviors.isEmpty()) {
            return ACSLPredicate.getTrue();
        }
        return this.predicate;
    }

    @Override
    public ACSLPredicate getCompletenessPredicate() {
        return ACSLPredicate.getTrue();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (!this.enclosingBehaviors.isEmpty()) {
            builder.append("for ");
            Joiner.on((String)", ").appendTo(builder, this.enclosingBehaviors.stream().map(x -> x.getName()).iterator());
            builder.append(": ");
        }
        return builder.toString() + this.kind + " " + this.predicate + ";";
    }

    public static enum AssertionKind {
        ASSERT("assert"),
        CHECK("check");

        private final String name;

        private AssertionKind(String pName) {
            this.name = pName;
        }

        public String toString() {
            return this.name;
        }
    }
}

