/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.acsl;

public enum ACSLBinaryOperator {
    AND("&&"),
    OR("||"),
    IMP("==>"),
    EQV("<==>"),
    XOR("^^"),
    EQ("=="),
    NEQ("!="),
    LEQ("<="),
    GEQ(">="),
    LT("<"),
    GT(">"),
    BAND("&"),
    BOR("|"),
    BIMP("-->"),
    BEQV("<-->"),
    BXOR("^"),
    PLUS("+"),
    MINUS("-"),
    TIMES("*"),
    DIVIDE("/"),
    MOD("%"),
    LSHIFT("<<"),
    RSHIFT(">>");

    private final String operator;

    private ACSLBinaryOperator(String s) {
        this.operator = s;
    }

    public static boolean isComparisonOperator(ACSLBinaryOperator op) {
        switch (op) {
            case EQ: 
            case NEQ: 
            case LEQ: 
            case GEQ: 
            case LT: 
            case GT: {
                return true;
            }
        }
        return false;
    }

    public static boolean isLogicalOperator(ACSLBinaryOperator op) {
        switch (op) {
            case AND: 
            case OR: 
            case IMP: 
            case EQV: 
            case XOR: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBitwiseOperator(ACSLBinaryOperator op) {
        switch (op) {
            case BAND: 
            case BOR: 
            case BIMP: 
            case BEQV: 
            case BXOR: {
                return true;
            }
        }
        return false;
    }

    public static boolean isArithmeticOperator(ACSLBinaryOperator op) {
        switch (op) {
            case PLUS: 
            case MINUS: 
            case TIMES: 
            case DIVIDE: 
            case MOD: 
            case LSHIFT: 
            case RSHIFT: {
                return true;
            }
        }
        return false;
    }

    public static boolean isCommutative(ACSLBinaryOperator op) {
        switch (op) {
            case EQ: 
            case NEQ: 
            case AND: 
            case OR: 
            case EQV: 
            case XOR: 
            case BAND: 
            case BOR: 
            case BEQV: 
            case BXOR: 
            case PLUS: 
            case TIMES: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.operator;
    }
}

