/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.acsl;

import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLBinaryOperator;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLTerm;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLTermVisitor;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLUnaryOperator;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLUnaryTerm;

public class ACSLBinaryTerm
implements ACSLTerm {
    private final ACSLTerm left;
    private final ACSLTerm right;
    private final ACSLBinaryOperator operator;

    public ACSLBinaryTerm(ACSLTerm pLeft, ACSLTerm pRight, ACSLBinaryOperator op) {
        assert (ACSLBinaryOperator.isArithmeticOperator(op) || ACSLBinaryOperator.isBitwiseOperator(op) || ACSLBinaryOperator.isComparisonOperator(op)) : String.format("ACSLTerm may only hold arithmetic, bitwise or comparison operator, %s is neither", new Object[]{op});
        switch (op) {
            case PLUS: 
            case MINUS: 
            case DIVIDE: 
            case TIMES: 
            case MOD: 
            case LSHIFT: 
            case RSHIFT: 
            case BAND: 
            case BOR: 
            case BXOR: 
            case EQ: 
            case NEQ: 
            case LEQ: 
            case GEQ: 
            case LT: 
            case GT: {
                this.left = pLeft;
                this.right = pRight;
                this.operator = op;
                break;
            }
            case BIMP: {
                this.left = new ACSLUnaryTerm(pLeft, ACSLUnaryOperator.BNEG);
                this.right = pRight;
                this.operator = ACSLBinaryOperator.BOR;
                break;
            }
            case BEQV: {
                this.left = new ACSLUnaryTerm(pLeft, ACSLUnaryOperator.BNEG);
                this.right = pRight;
                this.operator = ACSLBinaryOperator.BXOR;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown operator: " + op));
            }
        }
    }

    public String toString() {
        return this.left.toString() + this.operator + this.right;
    }

    public boolean equals(Object o) {
        if (o instanceof ACSLBinaryTerm) {
            ACSLBinaryTerm other = (ACSLBinaryTerm)o;
            if (this.operator.equals((Object)other.operator)) {
                return this.left.equals(other.left) && this.right.equals(other.right) || ACSLBinaryOperator.isCommutative(this.operator) && this.left.equals(other.right) && this.right.equals(other.left);
            }
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.left.hashCode() + 31 * this.right.hashCode() + this.operator.hashCode();
    }

    public ACSLTerm getLeft() {
        return this.left;
    }

    public ACSLTerm getRight() {
        return this.right;
    }

    public ACSLBinaryOperator getOperator() {
        return this.operator;
    }

    public ACSLBinaryTerm flipOperator() {
        ACSLBinaryOperator op;
        assert (ACSLBinaryOperator.isComparisonOperator(this.operator));
        switch (this.operator) {
            case EQ: {
                op = ACSLBinaryOperator.NEQ;
                break;
            }
            case NEQ: {
                op = ACSLBinaryOperator.EQ;
                break;
            }
            case LEQ: {
                op = ACSLBinaryOperator.GT;
                break;
            }
            case GEQ: {
                op = ACSLBinaryOperator.LT;
                break;
            }
            case LT: {
                op = ACSLBinaryOperator.GEQ;
                break;
            }
            case GT: {
                op = ACSLBinaryOperator.LEQ;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown BinaryOperator: " + this.operator));
            }
        }
        return new ACSLBinaryTerm(this.left, this.right, op);
    }

    @Override
    public boolean isAllowedIn(Class<?> clauseType) {
        return this.left.isAllowedIn(clauseType) && this.right.isAllowedIn(clauseType);
    }

    @Override
    public <R, X extends Exception> R accept(ACSLTermVisitor<R, X> visitor) throws X {
        return visitor.visit(this);
    }
}

