/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.acsl;

import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLBinaryOperator;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLPredicate;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLPredicateVisitor;

public class ACSLLogicalPredicate
extends ACSLPredicate {
    private final ACSLPredicate left;
    private final ACSLPredicate right;
    private final ACSLBinaryOperator operator;

    public ACSLLogicalPredicate(ACSLPredicate pLeft, ACSLPredicate pRight, ACSLBinaryOperator op) {
        this(pLeft, pRight, op, false);
    }

    public ACSLLogicalPredicate(ACSLPredicate pLeft, ACSLPredicate pRight, ACSLBinaryOperator op, boolean negated) {
        super(negated);
        assert (ACSLBinaryOperator.isLogicalOperator(op)) : "ACSLLogicalPredicate may only hold logical operator";
        switch (op) {
            case AND: 
            case OR: {
                this.left = pLeft;
                this.right = pRight;
                this.operator = op;
                break;
            }
            case XOR: {
                this.left = new ACSLLogicalPredicate(pLeft, pRight.negate(), ACSLBinaryOperator.AND);
                this.right = new ACSLLogicalPredicate(pLeft.negate(), pRight, ACSLBinaryOperator.AND);
                this.operator = ACSLBinaryOperator.OR;
                break;
            }
            case IMP: {
                this.left = pLeft.negate();
                this.right = pRight;
                this.operator = ACSLBinaryOperator.OR;
                break;
            }
            case EQV: {
                this.left = new ACSLLogicalPredicate(pLeft, pRight, ACSLBinaryOperator.AND);
                this.right = new ACSLLogicalPredicate(pLeft.negate(), pRight.negate(), ACSLBinaryOperator.AND);
                this.operator = ACSLBinaryOperator.OR;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown logical operator: " + op));
            }
        }
    }

    public String toString() {
        String positiveTemplate = "(%s)";
        String negativeTemplate = "!(%s)";
        String template = this.isNegated() ? negativeTemplate : positiveTemplate;
        return String.format(template, this.left.toString() + this.operator + this.right);
    }

    @Override
    public ACSLPredicate negate() {
        return new ACSLLogicalPredicate(this.left, this.right, this.operator, !this.isNegated());
    }

    @Override
    public ACSLPredicate simplify() {
        ACSLPredicate simpleLeft = this.left.simplify();
        ACSLPredicate simpleLeftNegated = simpleLeft.negate();
        ACSLPredicate simpleRight = this.right.simplify();
        ACSLPredicate simpleRightNegated = simpleRight.negate();
        switch (this.operator) {
            case AND: {
                if (simpleLeft.equals(ACSLLogicalPredicate.getFalse()) || simpleRight.equals(ACSLLogicalPredicate.getFalse()) || simpleLeft.isNegationOf(simpleRight)) {
                    return this.isNegated() ? ACSLLogicalPredicate.getTrue() : ACSLLogicalPredicate.getFalse();
                }
                if (simpleLeft.equals(simpleRight)) {
                    return this.isNegated() ? simpleLeftNegated : simpleLeft;
                }
                if (simpleLeft.equals(ACSLLogicalPredicate.getTrue())) {
                    return this.isNegated() ? simpleRightNegated : simpleRight;
                }
                if (simpleRight.equals(ACSLLogicalPredicate.getTrue())) {
                    return this.isNegated() ? simpleLeftNegated : simpleLeft;
                }
                if (!this.isNegated()) break;
                return new ACSLLogicalPredicate(simpleLeftNegated, simpleRightNegated, ACSLBinaryOperator.OR);
            }
            case OR: {
                if (simpleLeft.equals(ACSLLogicalPredicate.getTrue()) || simpleRight.equals(ACSLLogicalPredicate.getTrue()) || simpleLeft.isNegationOf(simpleRight)) {
                    return this.isNegated() ? ACSLLogicalPredicate.getFalse() : ACSLLogicalPredicate.getTrue();
                }
                if (simpleLeft.equals(simpleRight)) {
                    return this.isNegated() ? simpleLeftNegated : simpleLeft;
                }
                if (simpleLeft.equals(ACSLLogicalPredicate.getFalse())) {
                    return this.isNegated() ? simpleRightNegated : simpleRight;
                }
                if (simpleRight.equals(ACSLLogicalPredicate.getFalse())) {
                    return this.isNegated() ? simpleLeftNegated : simpleLeft;
                }
                if (!this.isNegated()) break;
                return new ACSLLogicalPredicate(simpleLeftNegated, simpleRightNegated, ACSLBinaryOperator.AND);
            }
            default: {
                throw new AssertionError((Object)("Unknown C logical operator: " + this.operator));
            }
        }
        assert (!this.isNegated());
        return new ACSLLogicalPredicate(simpleLeft, simpleRight, this.operator);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ACSLLogicalPredicate) {
            ACSLLogicalPredicate other = (ACSLLogicalPredicate)o;
            if (super.equals(o) && this.operator.equals((Object)other.operator)) {
                return this.left.equals(other.left) && this.right.equals(other.right) || ACSLBinaryOperator.isCommutative(this.operator) && this.left.equals(other.right) && this.right.equals(other.left);
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * (13 * this.left.hashCode() + 13 * this.right.hashCode() + this.operator.hashCode());
    }

    public ACSLPredicate getLeft() {
        return this.left;
    }

    public ACSLPredicate getRight() {
        return this.right;
    }

    public ACSLBinaryOperator getOperator() {
        return this.operator;
    }

    @Override
    public boolean isAllowedIn(Class<?> clauseType) {
        return this.left.isAllowedIn(clauseType) && this.right.isAllowedIn(clauseType);
    }

    @Override
    public <R, X extends Exception> R accept(ACSLPredicateVisitor<R, X> visitor) throws X {
        return visitor.visit(this);
    }
}

