/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.acsl;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLAnnotation;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLLoopInvariant;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLPredicate;
import org.sosy_lab.cpachecker.cfa.ast.acsl.Behavior;

public class ACSLLoopAnnotation
implements ACSLAnnotation {
    private final ACSLLoopInvariant lInvariant;
    private final ImmutableMap<List<Behavior>, ACSLLoopInvariant> additionalInvariants;

    ACSLLoopAnnotation(ACSLLoopInvariant invariant) {
        this(invariant, (Map<List<Behavior>, ACSLLoopInvariant>)ImmutableMap.of());
    }

    ACSLLoopAnnotation(Map<List<Behavior>, ACSLLoopInvariant> pAdditionalInvariants) {
        this(new ACSLLoopInvariant(ACSLPredicate.getTrue()), pAdditionalInvariants);
    }

    ACSLLoopAnnotation(ACSLLoopInvariant invariant, Map<List<Behavior>, ACSLLoopInvariant> pAdditionalInvariants) {
        this.lInvariant = new ACSLLoopInvariant(invariant.getPredicate().simplify());
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)pAdditionalInvariants.size());
        for (Map.Entry<List<Behavior>, ACSLLoopInvariant> entry : pAdditionalInvariants.entrySet()) {
            builder.put(entry.getKey(), (Object)new ACSLLoopInvariant(entry.getValue().getPredicate().simplify()));
        }
        this.additionalInvariants = builder.buildOrThrow();
    }

    @Override
    public List<Behavior> getDeclaredBehaviors() {
        return ImmutableList.of();
    }

    @Override
    public List<Behavior> getReferencedBehaviors() {
        ImmutableList.Builder referencedBehaviors = ImmutableList.builder();
        for (List behaviors : this.additionalInvariants.keySet()) {
            referencedBehaviors.addAll((Iterable)behaviors);
        }
        return referencedBehaviors.build();
    }

    @Override
    public ACSLPredicate getPredicateRepresentation() {
        return this.lInvariant.getPredicate();
    }

    @Override
    public ACSLPredicate getCompletenessPredicate() {
        return ACSLPredicate.getTrue();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.lInvariant.toString());
        if (!this.additionalInvariants.isEmpty()) {
            for (Map.Entry entry : this.additionalInvariants.entrySet()) {
                builder.append('\n').append("for ");
                Joiner.on((String)", ").appendTo(builder, ((List)entry.getKey()).stream().map(x -> x.getName()).iterator());
                builder.append(':');
                builder.append(((ACSLLoopInvariant)entry.getValue()).toString());
            }
        }
        return builder.toString();
    }
}

