/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.acsl;

import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLBinaryOperator;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLLogicExpression;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLLogicalPredicate;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLPredicateVisitor;

public abstract class ACSLPredicate
implements ACSLLogicExpression {
    private final boolean negated;

    protected ACSLPredicate(boolean pNegated) {
        this.negated = pNegated;
    }

    public static ACSLPredicate getTrue() {
        return TRUE.get();
    }

    public static ACSLPredicate getFalse() {
        return FALSE.get();
    }

    public abstract ACSLPredicate negate();

    public boolean isNegated() {
        return this.negated;
    }

    public abstract ACSLPredicate simplify();

    public ACSLPredicate and(ACSLPredicate other) {
        return new ACSLLogicalPredicate(this, other, ACSLBinaryOperator.AND);
    }

    public ACSLPredicate or(ACSLPredicate other) {
        return new ACSLLogicalPredicate(this, other, ACSLBinaryOperator.OR);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ACSLPredicate) {
            ACSLPredicate other = (ACSLPredicate)obj;
            return this.negated == other.negated;
        }
        return false;
    }

    public int hashCode() {
        return this.isNegated() ? -1 : 1;
    }

    public boolean isNegationOf(ACSLPredicate other) {
        return this.equals(other.negate());
    }

    public abstract <R, X extends Exception> R accept(ACSLPredicateVisitor<R, X> var1) throws X;

    private static class FALSE
    extends ACSLPredicate {
        private static final FALSE singleton = new FALSE();

        private static FALSE get() {
            return singleton;
        }

        private FALSE() {
            super(false);
        }

        public String toString() {
            return "false";
        }

        @Override
        public ACSLPredicate simplify() {
            return this;
        }

        @Override
        public ACSLPredicate negate() {
            return ACSLPredicate.getTrue();
        }

        @Override
        public boolean isNegated() {
            assert (!super.isNegated()) : "False should not be explicitly negated, should be True instead!";
            return false;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof FALSE) {
                assert (obj == singleton && this == singleton);
                return true;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return 19;
        }

        @Override
        public boolean isAllowedIn(Class<?> clauseType) {
            return true;
        }

        @Override
        public <R, X extends Exception> R accept(ACSLPredicateVisitor<R, X> visitor) throws X {
            return visitor.visitFalse();
        }
    }

    private static class TRUE
    extends ACSLPredicate {
        private static final TRUE singleton = new TRUE();

        private static TRUE get() {
            return singleton;
        }

        private TRUE() {
            super(false);
        }

        public String toString() {
            return "true";
        }

        @Override
        public ACSLPredicate simplify() {
            return this;
        }

        @Override
        public ACSLPredicate negate() {
            return ACSLPredicate.getFalse();
        }

        @Override
        public boolean isNegated() {
            assert (!super.isNegated()) : "True should not be explicitly negated, should be False instead!";
            return false;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof TRUE) {
                assert (obj == singleton && this == singleton);
                return true;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return 23;
        }

        @Override
        public boolean isAllowedIn(Class<?> clauseType) {
            return true;
        }

        @Override
        public <R, X extends Exception> R accept(ACSLPredicateVisitor<R, X> visitor) throws X {
            return visitor.visitTrue();
        }
    }
}

