/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.acsl;

import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLLogicalPredicate;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLPredicateVisitor;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLSimplePredicate;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLTermToCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLTernaryCondition;
import org.sosy_lab.cpachecker.cfa.ast.acsl.PredicateAt;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.expressions.And;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;
import org.sosy_lab.cpachecker.util.expressions.LeafExpression;
import org.sosy_lab.cpachecker.util.expressions.Or;

public class ACSLPredicateToExpressionTreeVisitor
implements ACSLPredicateVisitor<ExpressionTree<Object>, UnrecognizedCodeException> {
    private final ACSLTermToCExpressionVisitor termVisitor;

    public ACSLPredicateToExpressionTreeVisitor(ACSLTermToCExpressionVisitor pTermVisitor) {
        this.termVisitor = pTermVisitor;
    }

    @Override
    public ExpressionTree<Object> visitTrue() {
        return ExpressionTrees.getTrue();
    }

    @Override
    public ExpressionTree<Object> visitFalse() {
        return ExpressionTrees.getFalse();
    }

    @Override
    public ExpressionTree<Object> visit(ACSLSimplePredicate pred) throws UnrecognizedCodeException {
        return LeafExpression.of(pred.getTerm().accept(this.termVisitor), !pred.isNegated());
    }

    @Override
    public ExpressionTree<Object> visit(ACSLLogicalPredicate pred) throws UnrecognizedCodeException {
        switch (pred.getOperator()) {
            case AND: {
                if (pred.isNegated()) {
                    ExpressionTree<Object> leftTree = pred.getLeft().negate().accept(this);
                    ExpressionTree<Object> rightTree = pred.getRight().negate().accept(this);
                    return Or.of(leftTree, rightTree);
                }
                ExpressionTree<Object> leftTree = pred.getLeft().accept(this);
                ExpressionTree<Object> rightTree = pred.getRight().accept(this);
                return And.of(leftTree, rightTree);
            }
            case OR: {
                if (pred.isNegated()) {
                    ExpressionTree<Object> leftTree = pred.getLeft().negate().accept(this);
                    ExpressionTree<Object> rightTree = pred.getRight().negate().accept(this);
                    return And.of(leftTree, rightTree);
                }
                ExpressionTree<Object> leftTree = pred.getLeft().accept(this);
                ExpressionTree<Object> rightTree = pred.getRight().accept(this);
                return Or.of(leftTree, rightTree);
            }
        }
        throw new AssertionError((Object)"Operator should be AND or OR");
    }

    @Override
    public ExpressionTree<Object> visit(ACSLTernaryCondition pred) throws UnrecognizedCodeException {
        if (pred.isNegated()) {
            ExpressionTree<Object> left = Or.of(pred.getCondition().negate().accept(this), pred.getThen().negate().accept(this));
            ExpressionTree<Object> right = Or.of(pred.getCondition().accept(this), pred.getOtherwise().negate().accept(this));
            return And.of(left, right);
        }
        ExpressionTree<Object> left = And.of(pred.getCondition().accept(this), pred.getThen().accept(this));
        ExpressionTree<Object> right = And.of(pred.getCondition().negate().accept(this), pred.getOtherwise().accept(this));
        return Or.of(left, right);
    }

    @Override
    public ExpressionTree<Object> visit(PredicateAt pred) {
        throw new UnsupportedOperationException("There is currently no concrete translation of \\at available");
    }
}

