/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.acsl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.logging.Level;
import java_cup.runtime.Scanner;
import java_cup.runtime.Symbol;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLType;

@SuppressFBWarnings(value={"URF_UNREAD_FIELD", "DLS_DEAD_LOCAL_STORE"})
class ACSLScanner
implements Scanner {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    public static final int SINGLE_LINE_ANNOTATION = 2;
    public static final int MULTI_LINE_ANNOTATION = 4;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2};
    private static final int[] ZZ_CMAP_TOP = ACSLScanner.zzUnpackcmap_top();
    private static final String ZZ_CMAP_TOP_PACKED_0 = "\u0001\u0000\u0015\u0100\u0001\u0200\t\u0100\u0001\u0300\u000f\u0100\u0001\u0400\u00a7\u0100\b\u0500\u1020\u0100";
    private static final int[] ZZ_CMAP_BLOCKS = ACSLScanner.zzUnpackcmap_blocks();
    private static final String ZZ_CMAP_BLOCKS_PACKED_0 = "\t\u0000\u0001\u0001\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0005\u0012\u0000\u0001\u0006\u0001\u0007\u0001\b\u0002\u0000\u0001\t\u0001\n\u0001\u0000\u0001\u000b\u0001\f\u0001\r\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u0000\u0001\u0011\u0001\u0012\t\u0013\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u0018\u0001\u0019\u0001\u001a\u000b\u001b\u0001\u001c\b\u001b\u0001\u001d\u0005\u001b\u0001\u001e\u0001\u001f\u0001 \u0001!\u0001\"\u0001\u0000\u0001#\u0001$\u0001%\u0001&\u0001'\u0001(\u0001)\u0001*\u0001+\u0001,\u0001-\u0001.\u0001/\u00010\u00011\u00012\u00013\u00014\u00015\u00016\u00017\u00018\u0001\u001b\u00019\u0001\u001b\u0001:\u0001\u0000\u0001;\u0001\u0000\u0001<\u0006\u0000\u0001\u0003\u001a\u0000\u0001=\u01df\u0000\u0001=\u007f\u0000\u000b=\u001d\u0000\u0002\u0003\u0005\u0000\u0001=/\u0000\u0001=\u00a0\u0000\u0001=\u00ff\u0000\u0100>";
    private static final int[] ZZ_ACTION = ACSLScanner.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0003\u0000\u0001\u0001\u0001\u0002\u0002\u0001\u0002\u0003\u0001\u0004\u0001\u0002\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\u000b\u0001\f\u0001\r\u0002\u000e\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0002\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0002\u0001\u0016\u0001\u0017\f\u0014\u0001\u0018\u0001\u0019\u0001\t\u0002\u0000\u0001\u001a\u0001\u0000\u0001\u001b\u0001\u001c\u0001\u0000\u0002\u000e\u0001\u0000\u0001\u001d\u0001\u001e\u0001\u001f\u0001 \u0001!\u0005\u0000\u0001\"\u0011\u0014\u0001#\u0001$\u0001%\u0001&\u0001\u000e\u0002\u0000\u0001'\u0006\u0000\u000b\u0014\u0001(\u0001)\b\u0014\u0001*\u0001+\u0003\u0000\u0001,\u0002\u0000\u0004\u0014\u0001)\u0007\u0014\u0001)\u0006\u0014\u0004\u0000\u0001-\u0004\u0014\u0001.\u0005\u0014\u0002\u0000\u0001\u0014\u0001)\u0002\u0014\u0001\u0000\u0001/\u0002\u0000\u00010\u0006\u0014\u0004\u0000\u0001\u0014\u0001\u0000\u0001)\u00011\u00012\u00013\u00014\u00015\u0003\u0014\u00016\u0004\u0000\u0001\u0014\u0001\u0000\u00017\u0002\u0014\u0001\u0000\u0001)\u0002\u0000\u00018\u0006\u0000\u0001)\u000e\u0000\u0001)\n\u0000\u00019\u0006\u0000\u0001:\u0001;";
    private static final int[] ZZ_ROWMAP = ACSLScanner.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000?\u0000~\u0000\u00bd\u0000\u00bd\u0000\u00fc\u0000\u013b\u0000\u00bd\u0000\u017a\u0000\u01b9\u0000\u01f8\u0000\u00bd\u0000\u0237\u0000\u00bd\u0000\u00bd\u0000\u00bd\u0000\u00bd\u0000\u00bd\u0000\u0276\u0000\u00bd\u0000\u02b5\u0000\u02f4\u0000\u00bd\u0000\u00bd\u0000\u0333\u0000\u0372\u0000\u03b1\u0000\u00bd\u0000\u03f0\u0000\u00bd\u0000\u042f\u0000\u00bd\u0000\u046e\u0000\u04ad\u0000\u04ec\u0000\u052b\u0000\u056a\u0000\u05a9\u0000\u05e8\u0000\u0627\u0000\u0666\u0000\u06a5\u0000\u06e4\u0000\u0723\u0000\u0762\u0000\u07a1\u0000\u00bd\u0000\u07e0\u0000\u081f\u0000\u085e\u0000\u00bd\u0000\u01f8\u0000\u01f8\u0000\u00bd\u0000\u089d\u0000\u08dc\u0000\u091b\u0000\u095a\u0000\u00bd\u0000\u0999\u0000\u09d8\u0000\u00bd\u0000\u00bd\u0000\u0a17\u0000\u0a56\u0000\u0a95\u0000\u0ad4\u0000\u0b13\u0000\u00bd\u0000\u0b52\u0000\u0b91\u0000\u0bd0\u0000\u0c0f\u0000\u0c4e\u0000\u0c8d\u0000\u0ccc\u0000\u0d0b\u0000\u0d4a\u0000\u0d89\u0000\u0dc8\u0000\u0e07\u0000\u0e46\u0000\u0e85\u0000\u0ec4\u0000\u0f03\u0000\u0f42\u0000\u00bd\u0000\u00bd\u0000\u00bd\u0000\u00bd\u0000\u00bd\u0000\u0f81\u0000\u0fc0\u0000\u00bd\u0000\u0fff\u0000\u103e\u0000\u107d\u0000\u10bc\u0000\u10fb\u0000\u113a\u0000\u1179\u0000\u11b8\u0000\u11f7\u0000\u1236\u0000\u1275\u0000\u12b4\u0000\u12f3\u0000\u1332\u0000\u1371\u0000\u13b0\u0000\u13ef\u0000\u03f0\u0000\u142e\u0000\u146d\u0000\u14ac\u0000\u14eb\u0000\u152a\u0000\u1569\u0000\u15a8\u0000\u15e7\u0000\u1626\u0000\u00bd\u0000\u00bd\u0000\u1665\u0000\u16a4\u0000\u16e3\u0000\u00bd\u0000\u1722\u0000\u1761\u0000\u17a0\u0000\u17df\u0000\u181e\u0000\u185d\u0000\u03f0\u0000\u189c\u0000\u18db\u0000\u191a\u0000\u1959\u0000\u1998\u0000\u19d7\u0000\u1a16\u0000\u1a55\u0000\u1a94\u0000\u1ad3\u0000\u1b12\u0000\u1b51\u0000\u1b90\u0000\u1bcf\u0000\u1c0e\u0000\u1c4d\u0000\u1c8c\u0000\u1ccb\u0000\u00bd\u0000\u1d0a\u0000\u1d49\u0000\u1d88\u0000\u1dc7\u0000\u03f0\u0000\u1e06\u0000\u1e45\u0000\u1e84\u0000\u1ec3\u0000\u1f02\u0000\u1f41\u0000\u1f80\u0000\u1fbf\u0000\u1ffe\u0000\u203d\u0000\u207c\u0000\u20bb\u0000\u00bd\u0000\u20fa\u0000\u2139\u0000\u03f0\u0000\u2178\u0000\u21b7\u0000\u21f6\u0000\u2235\u0000\u2274\u0000\u22b3\u0000\u22f2\u0000\u2331\u0000\u2370\u0000\u23af\u0000\u23ee\u0000\u242d\u0000\u246c\u0000\u03f0\u0000\u00bd\u0000\u00bd\u0000\u00bd\u0000\u03f0\u0000\u24ab\u0000\u24ea\u0000\u2529\u0000\u03f0\u0000\u2568\u0000\u25a7\u0000\u25e6\u0000\u2625\u0000\u2664\u0000\u26a3\u0000\u03f0\u0000\u26e2\u0000\u2721\u0000\u2760\u0000\u00bd\u0000\u279f\u0000\u27de\u0000\u03f0\u0000\u281d\u0000\u285c\u0000\u289b\u0000\u28da\u0000\u2919\u0000\u2958\u0000\u2997\u0000\u29d6\u0000\u2a15\u0000\u2a54\u0000\u2a93\u0000\u2ad2\u0000\u2b11\u0000\u2b50\u0000\u2b8f\u0000\u2bce\u0000\u2c0d\u0000\u2c4c\u0000\u2c8b\u0000\u2cca\u0000\u2d09\u0000\u2d48\u0000\u2d87\u0000\u2dc6\u0000\u2e05\u0000\u2e44\u0000\u2e83\u0000\u2ec2\u0000\u2f01\u0000\u2f40\u0000\u2f7f\u0000\u2fbe\u0000\u00bd\u0000\u2ffd\u0000\u303c\u0000\u307b\u0000\u30ba\u0000\u30f9\u0000\u3138\u0000\u00bd\u0000\u00bd";
    private static final int[] ZZ_TRANS = ACSLScanner.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0003\u0004\u0002\u0005\u0001\u0006\u000b\u0004\u0001\u0007,\u0004\u0002\u0005\u0001\u0004\u0001\b\u0002\u0004\u0001\t\u0001\u0004\u0001\n\u0001\u000b\u0001\f\u0001\r\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u0018\u0001\u0019\u0001\u001a\u0001\u001b\u0001\u001c\u0001\u0004\u0003\u001d\u0001\u001e\u0001\u001f\u0001 \u0001!\u0001\"\u0001#\u0001$\u0001%\u0001&\u0001'\u0001(\u0002\u001d\u0001)\u0002\u001d\u0001*\u0005\u001d\u0001+\u0001,\u0001\u001d\u0001-\u0003\u001d\u0001.\u0001/\u0001\u0004\u0002\u0005\u0004\u0004\u0001\u0006\u0001\u0004\u0001\n\u0001\u000b\u0001\f\u0001\r\u0001\u000e\u0001\u000f\u00010\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u0018\u0001\u0019\u0001\u001a\u0001\u001b\u0001\u001c\u0001\u0004\u0003\u001d\u0001\u001e\u0001\u001f\u0001 \u0001!\u0001\"\u0001#\u0001$\u0001%\u0001&\u0001'\u0001(\u0002\u001d\u0001)\u0002\u001d\u0001*\u0005\u001d\u0001+\u0001,\u0001\u001d\u0001-\u0003\u001d\u0001.\u0001/\u0001\u0004\u0001\u0005A\u0000\u0001\u0004I\u0000\u00011\u0003\u0000\u00012/\u0000\u0001\bS\u0000\u00013'\u0000\u00024\u0004\u0000\u00024\u0001554\u000b\u0000\u00016D\u0000\u00017J\u0000\u00018\u00019\u0010\u0000\u00018\b\u0000\u00019\u0019\u0000\u0002\u0016\b\u0000\u00018\u00019\u0010\u0000\u00018\b\u0000\u00019\u0017\u0000\u0001:\u0005\u0000\u0001;\u0001<>\u0000\u0001=>\u0000\u0001>\u0001?8\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0019\u001d+\u0000\u0001@\u0001A\b\u0000\u0001B\u0002\u0000\u0001C\u0001\u0000\u0001D)\u0000\u0001E/\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0002\u001d\u0001F\u0016\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0013\u001d\u0001G\u0005\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0005\u001d\u0001H\t\u001d\u0001I\t\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\b\u001d\u0001J\u0006\u001d\u0001K\t\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\t\u001d\u0001L\u0005\u001d\u0001M\t\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u000e\u001d\u0001N\n\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\f\u001d\u0001O\u0002\u001d\u0001P\t\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u000e\u001d\u0001Q\n\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u000f\u001d\u0001R\t\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0005\u001d\u0001S\u0013\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\b\u001d\u0001T\u0001U\u000f\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u000e\u001d\u0001V\n\u001d?\u0000\u0001W\u0014\u0000\u0001\bG\u0000\u0001X>\u0000\u0001Y<\u0000\u0001ZB\u0000\u0001[\u0011\u0000\u0001[,\u0000\u00018\u0011\u0000\u00018 \u0000\u0001\\E\u0000\u0001]?\u0000\u0001^_\u0000\u0001_(\u0000\u0001`\r\u0000\u0001a;\u0000\u0001b7\u0000\u0001cK\u0000\u0001d\u001c\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u000f\u001d\u0001e\t\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0013\u001d\u0001f\u0005\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\b\u001d\u0001g\u0010\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u000f\u001d\u0001h\t\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0001\u001d\u0001i\u0003\u001d\u0001j\u0013\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\r\u001d\u0001k\u000b\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0013\u001d\u0001l\u0005\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0015\u001d\u0001m\u0003\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0013\u001d\u0001n\u0005\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u000f\u001d\u0001o\t\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0012\u001d\u0001p\u0006\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0014\u001d\u0001q\u0004\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u000e\u001d\u0001r\u0001s\t\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0001\u001d\u0001t\u000f\u001d\u0001u\u0007\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u000f\u001d\u0001v\t\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0007\u001d\u0001w\u0010\u001d\u0001x\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0013\u001d\u0001y\u0005\u001d\u001c\u0000\u0001z>\u0000\u0001{Q\u0000\u0001|A\u0000\u0001}D\u0000\u0001~0\u0000\u0001\u007fM\u0000\u0001\u0080@\u0000\u0001\u0081\u0019\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u000f\u001d\u0001t\t\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0005\u001d\u0001\u0082\u000f\u001d\u0001\u0083\u0003\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0001\u001d\u0001\u0084\u0017\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\f\u001d\u0001\u0085\f\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0012\u001d\u0001\u0086\u0006\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0003\u001d\u0001\u0087\u0015\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0010\u001d\u0001\u0088\b\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\n\u001d\u0001\u0089\u000e\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0002\u001d\u0001\u008a\u0016\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0015\u001d\u0001\u008b\u0003\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0001\u001d\u0001\u008c\u0017\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0005\u001d\u0001\u008d\u0013\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0007\u001d\u0001\u008e\u0011\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0010\u001d\u0001\u008f\b\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\f\u001d\u0001\u0086\f\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0015\u001d\u0001\u0090\u0003\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0012\u001d\u0001\u0091\u0006\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u000e\u001d\u0001\u0092\n\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0005\u001d\u0001\u0093\u0013\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\t\u001d\u0001\u0094\u000f\u001d9\u0000\u0001\u0095>\u0000\u0001\u0096,\u0000\u0001\u0097R\u0000\u0001\u0098.\u0000\u0001\u0099)\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0012\u001d\u0001\u009a\u0006\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\r\u001d\u0001\u009b\u000b\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0016\u001d\u0001\u009c\u0002\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0005\u001d\u0001\u009d\u0013\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u000b\u001d\u0001\u009e\r\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\f\u001d\u0001\u009f\f\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u000f\u001d\u0001\u00a0\t\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\f\u001d\u0001\u00a1\f\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0012\u001d\u0001\u00a2\u0006\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0014\u001d\u0001\u0086\u0004\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0007\u001d\u0001\u00a3\u0011\u001d\u0005\u0000\u0001\u00a4\u0002\u0000\u0001\u00a4\u0001\u0000\u0001\u00a4\u000b\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0019\u001d\n\u0000\u0001\u00a5\u000b\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0019\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\t\u001d\u0001\u00a6\u000f\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0014\u001d\u0001\u00a7\u0004\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0005\u001d\u0001\u00a8\u0013\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u000f\u001d\u0001\u00a9\t\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0007\u001d\u0001w\u0011\u001d:\u0000\u0001\u00aa/\u0000\u0001\u00abE\u0000\u0001\u00ac>\u0000\u0001\u00ad\"\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0014\u001d\u0001\u00ae\u0004\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0005\u001d\u0001\u00af\u0013\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\t\u001d\u0001\u00b0\u000f\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0001\u001d\u0001\u00b1\u0017\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0005\u001d\u0001\u00b2\u0013\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\t\u001d\u0001\u00b3\u000f\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0005\u001d\u0001\u0086\u0013\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0005\u001d\u0001\u00b4\u0013\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0005\u001d\u0001i\u0013\u001d\u0005\u0000\u0001\u00a4\u0002\u0000\u0001\u00a4\u0001\u0000\u0001\u00a4\u001f\u0000\u0001\u00b5\u0004\u0000\u0001\u00b6\u0002\u0000\u0001\u00b7;\u0000\u0001\u00b8%\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0012\u001d\u0001\u00b9\u0006\u001d\u0005\u0000\u0001\u00ba\u0002\u0000\u0001\u00ba\u0001\u0000\u0001\u00ba\u000b\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0019\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0004\u001d\u0001\u00bb\u0014\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0006\u001d\u0001\u00bc\u0012\u001d9\u0000\u0001\u00bd7\u0000\u0001\u00beF\u0000\u0001\u00bf\u001a\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0013\u001d\u0001\u00c0\u0005\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u000f\u001d\u0001\u00c1\t\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u000e\u001d\u0001\u0086\n\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0014\u001d\u0001\u00c2\u0004\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u000e\u001d\u0001\u00c3\n\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0013\u001d\u0001\u00c4\u0005\u001d5\u0000\u0001\u00c5=\u0000\u0001\u00c6?\u0000\u0001\u00c7=\u0000\u0001\u00c8 \u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0005\u001d\u0001\u00c9\u0013\u001d\u0005\u0000\u0001\u00ba\u0002\u0000\u0001\u00ba\u0001\u0000\u0001\u00ba$\u0000\u0001\u00b6\u0014\u0000\u0001\u00ca\u0002\u0000\u0001\u00ca\u0001\u0000\u0001\u00ca\u000b\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0019\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0012\u001d\u0001\u00cb\u0006\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0005\u001d\u0001\u00cc\u0013\u001d\u0016\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0014\u001d\u0001\u00cd\u0004\u001d;\u0000\u0001\u00ce=\u0000\u0001\u00cf8\u0000\u0001\u00d0F\u0000\u0001\u00d1\u0018\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0013\u001d\u0001\u00d2\u0005\u001d\u0005\u0000\u0001\u00ca\u0002\u0000\u0001\u00ca\u0001\u0000\u0001\u00ca\u001e\u0000\u0001\u00d3\u0005\u0000\u0001\u00b6\u0002\u0000\u0001\u00d4\u0006\u0000\u0001\u00d5\u000f\u0000\u0001\u00d6\u000b\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0019\u001d\n\u0000\u0001\u00d7\u000b\u0000\u0002\u001d\u0007\u0000\u0003\u001d\u0004\u0000\u0019\u001d(\u0000\u0001\u00d8C\u0000\u0001\u00d98\u0000\u0001\u00daE\u0000\u0001\u00dbE\u0000\u0001\u00dc7\u0000\u0001\u00dd8\u0000\u0001\u00de>\u0000\u0001\u00dfH\u0000\u0001\u00e0\u0011\u0000\u0001\u00ba\u0002\u0000\u0001\u00ba\u0001\u0000\u0001\u00bal\u0000\u0001\u00e1-\u0000\u0001\u00e2K\u0000\u0001\u00e3?\u0000\u0001\u00e44\u0000\u0001\u00e5>\u0000\u0001\u00e6>\u0000\u0001\u00cfB\u0000\u0001\u00e7G\u0000\u0001\u00cf3\u0000\u0001\u00e8I\u0000\u0001\u00e94\u0000\u0001\u00ea>\u0000\u0001\u00eb7\u0000\u0001\u00ec\u001c\u0000\u0001\u00ed\u0002\u0000\u0001\u00ed\u0001\u0000\u0001\u00edn\u0000\u0001\u00d9+\u0000\u0001\u00ee>\u0000\u0001\u00efK\u0000\u0001\u00f0\u000f\u0000\u0001\u00ed\u0002\u0000\u0001\u00ed\u0001\u0000\u0001\u00ed$\u0000\u0001\u00b6\u0002\u0000\u0001\u00b7H\u0000\u0001\u00f1>\u0000\u0001\u00f2<\u0000\u0001\u00f33\u0000\u0001\u00f4>\u0000\u0001\u00f5D\u0000\u0001\u00f6>\u0000\u0001\u00f7A\u0000\u0001\u00f8>\u0000\u0001\u00f9?\u0000\u0001\u00fa>\u0000\u0001\u00fb\t\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = ACSLScanner.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0003\u0000\u0002\t\u0002\u0001\u0001\t\u0003\u0001\u0001\t\u0001\u0001\u0005\t\u0001\u0001\u0001\t\u0002\u0001\u0002\t\u0003\u0001\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0001\t\u000e\u0001\u0001\t\u0001\u0001\u0002\u0000\u0001\t\u0001\u0000\u0001\u0001\u0001\t\u0001\u0000\u0002\u0001\u0001\u0000\u0001\t\u0002\u0001\u0002\t\u0005\u0000\u0001\t\u0011\u0001\u0005\t\u0002\u0000\u0001\t\u0006\u0000\u0015\u0001\u0002\t\u0003\u0000\u0001\t\u0002\u0000\u0013\u0001\u0004\u0000\u0001\t\n\u0001\u0002\u0000\u0004\u0001\u0001\u0000\u0001\t\u0002\u0000\u0007\u0001\u0004\u0000\u0001\u0001\u0001\u0000\u0002\u0001\u0003\t\u0005\u0001\u0004\u0000\u0001\u0001\u0001\u0000\u0003\u0001\u0001\u0000\u0001\t\u0002\u0000\u0001\u0001\u0006\u0000\u0001\u0001\u000e\u0000\u0001\u0001\n\u0000\u0001\t\u0006\u0000\u0002\t";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private boolean zzAtEOF;
    private int zzFinalHighSurrogate = 0;
    private int yyline;
    private int yycolumn;
    private long yychar;
    private boolean zzAtBOL = true;
    private boolean zzEOFDone;
    StringBuilder builder = new StringBuilder();
    int currentAnnotation = -1;
    Queue<Symbol> symbols = new ArrayDeque<Symbol>();
    boolean pred_start = false;
    LogManager logger;

    private static int[] zzUnpackcmap_top() {
        int[] result = new int[4352];
        int offset = 0;
        offset = ACSLScanner.zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackcmap_top(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackcmap_blocks() {
        int[] result = new int[1536];
        int offset = 0;
        offset = ACSLScanner.zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackcmap_blocks(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAction() {
        int[] result = new int[251];
        int offset = 0;
        offset = ACSLScanner.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[251];
        int offset = 0;
        offset = ACSLScanner.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[12663];
        int offset = 0;
        offset = ACSLScanner.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[251];
        int offset = 0;
        offset = ACSLScanner.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private Symbol symbol(int type) {
        return new Symbol(type, this.yyline, this.yycolumn);
    }

    private Symbol symbol(int type, Object value) {
        return new Symbol(type, this.yyline, this.yycolumn, value);
    }

    public Symbol getNext() throws IOException {
        if (this.symbols.isEmpty()) {
            this.bufferNextAnnotation();
            ++this.currentAnnotation;
        }
        if (!this.symbols.isEmpty()) {
            return this.symbols.poll();
        }
        return this.symbol(0);
    }

    private void bufferNextAnnotation() throws IOException {
        Symbol token = this.next_token();
        if (token.sym == 0) {
            return;
        }
        this.symbols.add(this.symbol(46));
        boolean invalidAnnotation = false;
        while (token.sym != 0 && token.sym != 62) {
            if (token.sym == 63) {
                this.logger.logf(Level.INFO, "Unsupported character: <%s>. Ignoring current annotation", new Object[]{this.yytext()});
                invalidAnnotation = true;
            }
            this.symbols.add(token);
            if (this.pred_start) {
                this.symbols.add(this.symbol(53));
                this.pred_start = false;
            }
            token = this.next_token();
        }
        this.symbols.add(this.symbol(62));
        assert (!this.pred_start);
        if (invalidAnnotation) {
            this.symbols.clear();
            this.symbols.add(this.symbol(63));
        }
    }

    public int getCurrentAnnotation() {
        return this.currentAnnotation;
    }

    ACSLScanner(Reader in, LogManager pLogger) {
        this.logger = pLogger;
        this.zzReader = in;
    }

    private static int zzCMap(int input) {
        int offset = input & 0xFF;
        return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
    }

    private boolean zzRefill() throws IOException {
        int requested;
        int numRead;
        if (this.zzStartRead > 0) {
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length - this.zzFinalHighSurrogate) {
            char[] newBuffer = new char[this.zzBuffer.length * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, requested = this.zzBuffer.length - this.zzEndRead)) == 0) {
            throw new IOException("Reader returned 0 characters. See JFlex examples/zero-reader for a workaround.");
        }
        if (numRead > 0) {
            this.zzEndRead += numRead;
            if (Character.isHighSurrogate(this.zzBuffer[this.zzEndRead - 1])) {
                if (numRead == requested) {
                    --this.zzEndRead;
                    this.zzFinalHighSurrogate = 1;
                } else {
                    int c = this.zzReader.read();
                    if (c == -1) {
                        return true;
                    }
                    this.zzBuffer[this.zzEndRead++] = (char)c;
                }
            }
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzEOFDone = false;
        this.yyResetPosition();
        this.zzLexicalState = 0;
        if (this.zzBuffer.length > 16384) {
            this.zzBuffer = new char[16384];
        }
    }

    private final void yyResetPosition() {
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzCurrentPos = 0;
        this.zzMarkedPos = 0;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzFinalHighSurrogate = 0;
        this.yyline = 0;
        this.yycolumn = 0;
        this.yychar = 0L;
    }

    public final boolean yyatEOF() {
        return this.zzAtEOF;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int position) {
        return this.zzBuffer[this.zzStartRead + position];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private static void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            ACSLScanner.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    private void zzDoEOF() throws IOException {
        if (!this.zzEOFDone) {
            this.zzEOFDone = true;
            this.yyclose();
        }
    }

    public Symbol next_token() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block124: while (true) {
            int zzInput;
            boolean eof;
            int zzCurrentPosL;
            int zzCharCount;
            int zzMarkedPosL = this.zzMarkedPos;
            boolean zzR = false;
            block125: for (zzCurrentPosL = this.zzStartRead; zzCurrentPosL < zzMarkedPosL; zzCurrentPosL += zzCharCount) {
                int zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
                zzCharCount = Character.charCount(zzCh);
                switch (zzCh) {
                    case 11: 
                    case 12: 
                    case 133: 
                    case 8232: 
                    case 8233: {
                        ++this.yyline;
                        this.yycolumn = 0;
                        zzR = false;
                        continue block125;
                    }
                    case 13: {
                        ++this.yyline;
                        this.yycolumn = 0;
                        zzR = true;
                        continue block125;
                    }
                    case 10: {
                        if (zzR) {
                            zzR = false;
                            continue block125;
                        }
                        ++this.yyline;
                        this.yycolumn = 0;
                        continue block125;
                    }
                    default: {
                        zzR = false;
                        this.yycolumn += zzCharCount;
                    }
                }
            }
            if (zzR) {
                boolean zzPeek;
                if (zzMarkedPosL < zzEndReadL) {
                    zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                } else if (this.zzAtEOF) {
                    zzPeek = false;
                } else {
                    eof = this.zzRefill();
                    zzEndReadL = this.zzEndRead;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    if (eof) {
                        zzPeek = false;
                    } else {
                        boolean bl = zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                    }
                }
                if (zzPeek) {
                    --this.yyline;
                }
            }
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + ACSLScanner.zzCMap(zzInput)];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                this.zzDoEOF();
                return this.symbol(0, this.yytext());
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: 
                case 60: {
                    continue block124;
                }
                case 2: {
                    return this.symbol(63);
                }
                case 61: {
                    continue block124;
                }
                case 3: {
                    this.yybegin(0);
                    return this.symbol(62);
                }
                case 62: {
                    continue block124;
                }
                case 4: {
                    this.pred_start = true;
                    return this.symbol(11);
                }
                case 63: {
                    continue block124;
                }
                case 5: {
                    return this.symbol(33);
                }
                case 64: {
                    continue block124;
                }
                case 6: {
                    return this.symbol(27);
                }
                case 65: {
                    continue block124;
                }
                case 7: {
                    this.pred_start = true;
                    return this.symbol(36);
                }
                case 66: {
                    continue block124;
                }
                case 8: {
                    return this.symbol(37);
                }
                case 67: {
                    continue block124;
                }
                case 9: {
                    return this.symbol(26);
                }
                case 68: {
                    continue block124;
                }
                case 10: {
                    return this.symbol(29);
                }
                case 69: {
                    continue block124;
                }
                case 11: {
                    return this.symbol(55);
                }
                case 70: {
                    continue block124;
                }
                case 12: {
                    return this.symbol(30);
                }
                case 71: {
                    continue block124;
                }
                case 13: {
                    return this.symbol(32);
                }
                case 72: {
                    continue block124;
                }
                case 14: {
                    this.builder.setLength(0);
                    String matched = this.yytext().toLowerCase();
                    while (matched.endsWith("u") || matched.endsWith("l")) {
                        matched = matched.substring(0, matched.length() - 1);
                    }
                    return this.symbol(42, new BigInteger(this.builder.append(matched).toString()));
                }
                case 73: {
                    continue block124;
                }
                case 15: {
                    this.pred_start = true;
                    return this.symbol(51);
                }
                case 74: {
                    continue block124;
                }
                case 16: {
                    this.pred_start = true;
                    return this.symbol(38);
                }
                case 75: {
                    continue block124;
                }
                case 17: {
                    return this.symbol(17);
                }
                case 76: {
                    continue block124;
                }
                case 18: {
                    return this.symbol(16);
                }
                case 77: {
                    continue block124;
                }
                case 19: {
                    this.pred_start = true;
                    return this.symbol(52);
                }
                case 78: {
                    continue block124;
                }
                case 20: {
                    this.builder.setLength(0);
                    return this.symbol(44, this.builder.append(this.yytext()).toString());
                }
                case 79: {
                    continue block124;
                }
                case 21: {
                    return this.symbol(4);
                }
                case 80: {
                    continue block124;
                }
                case 22: {
                    return this.symbol(5);
                }
                case 81: {
                    continue block124;
                }
                case 23: {
                    return this.symbol(22);
                }
                case 82: {
                    continue block124;
                }
                case 24: {
                    return this.symbol(19);
                }
                case 83: {
                    continue block124;
                }
                case 25: {
                    return this.symbol(23);
                }
                case 84: {
                    continue block124;
                }
                case 26: {
                    return this.symbol(13);
                }
                case 85: {
                    continue block124;
                }
                case 27: {
                    this.builder.setLength(0);
                    return this.symbol(43, this.builder.append(this.yytext()).toString());
                }
                case 86: {
                    continue block124;
                }
                case 28: {
                    this.pred_start = true;
                    return this.symbol(6);
                }
                case 87: {
                    continue block124;
                }
                case 29: {
                    return this.symbol(34);
                }
                case 88: {
                    continue block124;
                }
                case 30: {
                    return this.symbol(14);
                }
                case 89: {
                    continue block124;
                }
                case 31: {
                    return this.symbol(12);
                }
                case 90: {
                    continue block124;
                }
                case 32: {
                    return this.symbol(15);
                }
                case 91: {
                    continue block124;
                }
                case 33: {
                    return this.symbol(35);
                }
                case 92: {
                    continue block124;
                }
                case 34: {
                    this.pred_start = true;
                    return this.symbol(10);
                }
                case 93: {
                    continue block124;
                }
                case 35: {
                    this.pred_start = true;
                    return this.symbol(7);
                }
                case 94: {
                    continue block124;
                }
                case 36: {
                    this.yybegin(4);
                }
                case 95: {
                    continue block124;
                }
                case 37: {
                    this.yybegin(2);
                }
                case 96: {
                    continue block124;
                }
                case 38: {
                    return this.symbol(20);
                }
                case 97: {
                    continue block124;
                }
                case 39: {
                    this.pred_start = true;
                    return this.symbol(8);
                }
                case 98: {
                    continue block124;
                }
                case 40: {
                    return this.symbol(54);
                }
                case 99: {
                    continue block124;
                }
                case 41: {
                    this.builder.setLength(0);
                    return this.symbol(45, new ACSLType(this.builder.append(this.yytext()).toString()));
                }
                case 100: {
                    continue block124;
                }
                case 42: {
                    return this.symbol(21);
                }
                case 101: {
                    continue block124;
                }
                case 43: {
                    this.pred_start = true;
                    return this.symbol(9);
                }
                case 102: {
                    continue block124;
                }
                case 44: {
                    return this.symbol(58);
                }
                case 103: {
                    continue block124;
                }
                case 45: {
                    return this.symbol(2);
                }
                case 104: {
                    continue block124;
                }
                case 46: {
                    this.pred_start = true;
                    return this.symbol(49);
                }
                case 105: {
                    continue block124;
                }
                case 47: {
                    return this.symbol(3);
                }
                case 106: {
                    continue block124;
                }
                case 48: {
                    this.pred_start = true;
                    return this.symbol(48);
                }
                case 107: {
                    continue block124;
                }
                case 49: {
                    return this.symbol(28);
                }
                case 108: {
                    continue block124;
                }
                case 50: {
                    return this.symbol(61);
                }
                case 109: {
                    continue block124;
                }
                case 51: {
                    return this.symbol(60);
                }
                case 110: {
                    continue block124;
                }
                case 52: {
                    return this.symbol(59);
                }
                case 111: {
                    continue block124;
                }
                case 53: {
                    this.pred_start = true;
                    return this.symbol(41);
                }
                case 112: {
                    continue block124;
                }
                case 54: {
                    this.pred_start = true;
                    return this.symbol(40);
                }
                case 113: {
                    continue block124;
                }
                case 55: {
                    return this.symbol(50);
                }
                case 114: {
                    continue block124;
                }
                case 56: {
                    this.pred_start = true;
                    return this.symbol(39);
                }
                case 115: {
                    continue block124;
                }
                case 57: {
                    this.pred_start = true;
                    return this.symbol(47);
                }
                case 116: {
                    continue block124;
                }
                case 58: {
                    return this.symbol(56);
                }
                case 117: {
                    continue block124;
                }
                case 59: {
                    return this.symbol(57);
                }
                case 118: {
                    continue block124;
                }
            }
            ACSLScanner.zzScanError(1);
        }
    }
}

