/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.acsl;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLBinaryOperator;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLBinaryTerm;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLPredicate;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLPredicateVisitor;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLTerm;

public class ACSLSimplePredicate
extends ACSLPredicate {
    private final ACSLTerm term;

    public ACSLSimplePredicate(ACSLTerm pTerm) {
        this(pTerm, false);
    }

    public ACSLSimplePredicate(ACSLTerm pTerm, boolean negated) {
        super(negated);
        Preconditions.checkArgument((pTerm instanceof ACSLBinaryTerm && ACSLBinaryOperator.isComparisonOperator(((ACSLBinaryTerm)pTerm).getOperator()) ? 1 : 0) != 0, (Object)"Simple predicate should hold comparison term.");
        this.term = pTerm;
    }

    public String toString() {
        String positiveTemplate = "%s";
        String negativeTemplate = "!(%s)";
        String template = this.isNegated() ? negativeTemplate : positiveTemplate;
        return String.format(template, this.term.toString());
    }

    @Override
    public ACSLPredicate negate() {
        return new ACSLSimplePredicate(this.term, !this.isNegated());
    }

    @Override
    public ACSLPredicate simplify() {
        if (this.isNegated()) {
            return new ACSLSimplePredicate(((ACSLBinaryTerm)this.term).flipOperator());
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ACSLSimplePredicate) {
            ACSLSimplePredicate other = (ACSLSimplePredicate)o;
            return super.equals(o) && this.term.equals(other.term);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 3 * this.term.hashCode();
    }

    public ACSLTerm getTerm() {
        return this.term;
    }

    @Override
    public boolean isAllowedIn(Class<?> clauseType) {
        return this.term.isAllowedIn(clauseType);
    }

    @Override
    public <R, X extends Exception> R accept(ACSLPredicateVisitor<R, X> visitor) throws X {
        return visitor.visit(this);
    }
}

