/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.acsl;

import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLBinaryOperator;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLLogicalPredicate;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLPredicate;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLPredicateVisitor;

public class ACSLTernaryCondition
extends ACSLPredicate {
    private final ACSLPredicate condition;
    private final ACSLPredicate then;
    private final ACSLPredicate otherwise;

    public ACSLTernaryCondition(ACSLPredicate p1, ACSLPredicate p2, ACSLPredicate p3) {
        this(p1, p2, p3, false);
    }

    public ACSLTernaryCondition(ACSLPredicate p1, ACSLPredicate p2, ACSLPredicate p3, boolean negated) {
        super(negated);
        this.condition = p1;
        this.then = p2;
        this.otherwise = p3;
    }

    public ACSLPredicate getCondition() {
        return this.condition;
    }

    public ACSLPredicate getThen() {
        return this.then;
    }

    public ACSLPredicate getOtherwise() {
        return this.otherwise;
    }

    public String toString() {
        return this.condition.toString() + " ? " + this.then + " : " + this.otherwise;
    }

    @Override
    public ACSLPredicate negate() {
        return new ACSLTernaryCondition(this.condition, this.then, this.otherwise, !this.isNegated());
    }

    @Override
    public ACSLPredicate simplify() {
        ACSLPredicate simpleCondition = this.condition.simplify();
        ACSLPredicate simpleConditionNegated = simpleCondition.negate();
        ACSLPredicate simpleThen = this.then.simplify();
        ACSLPredicate simpleThenNegated = simpleThen.negate();
        ACSLPredicate simpleOtherwise = this.otherwise.simplify();
        ACSLPredicate simpleOtherwiseNegated = simpleOtherwise.negate();
        if (simpleCondition.equals(ACSLTernaryCondition.getTrue())) {
            return this.isNegated() ? simpleThenNegated : simpleThen;
        }
        if (simpleCondition.equals(ACSLTernaryCondition.getFalse())) {
            return this.isNegated() ? simpleOtherwiseNegated : simpleOtherwise;
        }
        if (this.then.equals(this.otherwise) || simpleThen.equals(simpleOtherwise)) {
            return this.isNegated() ? simpleThenNegated : simpleThen;
        }
        return this.isNegated() ? new ACSLLogicalPredicate(simpleConditionNegated, simpleThenNegated, ACSLBinaryOperator.OR).and(new ACSLLogicalPredicate(simpleCondition, simpleOtherwiseNegated, ACSLBinaryOperator.OR)) : new ACSLTernaryCondition(simpleCondition, simpleThen, simpleOtherwise);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ACSLTernaryCondition) {
            ACSLTernaryCondition other = (ACSLTernaryCondition)o;
            return super.equals(o) && this.condition.equals(other.condition) && this.then.equals(other.then) && this.otherwise.equals(other.otherwise);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * (19 * this.condition.hashCode() + 11 * this.then.hashCode() + this.otherwise.hashCode());
    }

    @Override
    public boolean isAllowedIn(Class<?> clauseType) {
        return this.condition.isAllowedIn(clauseType) && this.then.isAllowedIn(clauseType) && this.otherwise.isAllowedIn(clauseType);
    }

    @Override
    public <R, X extends Exception> R accept(ACSLPredicateVisitor<R, X> visitor) throws X {
        return visitor.visit(this);
    }
}

