/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.acsl;

import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLBinaryOperator;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLDefaultLabel;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLLogicalPredicate;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLPredicate;
import org.sosy_lab.cpachecker.cfa.ast.acsl.AssumesClause;
import org.sosy_lab.cpachecker.cfa.ast.acsl.EnsuresClause;
import org.sosy_lab.cpachecker.cfa.ast.acsl.PredicateAt;
import org.sosy_lab.cpachecker.cfa.ast.acsl.RequiresClause;

public class Behavior {
    private final String name;
    private final EnsuresClause ensuresClause;
    private final RequiresClause requiresClause;
    private final AssumesClause assumesClause;

    public Behavior(String pName) {
        this(pName, new EnsuresClause(ACSLPredicate.getTrue()), new RequiresClause(ACSLPredicate.getTrue()), new AssumesClause(ACSLPredicate.getTrue()));
    }

    public Behavior(String pName, EnsuresClause ens, RequiresClause req, AssumesClause ass) {
        this.name = pName;
        this.ensuresClause = new EnsuresClause(ens.getPredicate().simplify());
        this.requiresClause = new RequiresClause(req.getPredicate().simplify());
        this.assumesClause = new AssumesClause(ass.getPredicate().simplify());
    }

    public String getName() {
        return this.name;
    }

    public AssumesClause getAssumesClause() {
        return this.assumesClause;
    }

    public ACSLPredicate getPreStatePredicate() {
        ACSLPredicate requiresPredicate = this.requiresClause.getPredicate();
        ACSLPredicate negatedAssumesPredicate = this.assumesClause.getPredicate().negate();
        return new ACSLLogicalPredicate(requiresPredicate, negatedAssumesPredicate, ACSLBinaryOperator.OR);
    }

    public ACSLPredicate getPostStatePredicate() {
        ACSLPredicate ensuresPredicate = this.ensuresClause.getPredicate();
        ACSLPredicate negatedAssumesPredicate = new PredicateAt(this.assumesClause.getPredicate(), ACSLDefaultLabel.OLD).negate();
        return new ACSLLogicalPredicate(ensuresPredicate, negatedAssumesPredicate, ACSLBinaryOperator.OR);
    }

    public String toString() {
        return "behavior " + this.name + ":\n" + this.assumesClause + "\n" + this.requiresClause + "\n" + this.ensuresClause;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Behavior)) {
            return false;
        }
        Behavior behavior = (Behavior)other;
        return Objects.equals(this.name, behavior.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

