/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.acsl;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLPredicate;
import org.sosy_lab.cpachecker.cfa.ast.acsl.AssumesClause;
import org.sosy_lab.cpachecker.cfa.ast.acsl.Behavior;
import org.sosy_lab.cpachecker.cfa.ast.acsl.EnsuresClause;
import org.sosy_lab.cpachecker.cfa.ast.acsl.RequiresClause;

public class BehaviorBuilder {
    private String behaviorName;
    private EnsuresClause ensuresClause = new EnsuresClause(ACSLPredicate.getTrue());
    private RequiresClause requiresClause = new RequiresClause(ACSLPredicate.getTrue());
    private AssumesClause assumesClause = new AssumesClause(ACSLPredicate.getTrue());

    @CanIgnoreReturnValue
    public BehaviorBuilder setBehaviorName(String name) {
        this.behaviorName = name;
        return this;
    }

    @CanIgnoreReturnValue
    public BehaviorBuilder add(Object o) {
        if (o instanceof RequiresClause) {
            return this.add((RequiresClause)o);
        }
        if (o instanceof EnsuresClause) {
            return this.add((EnsuresClause)o);
        }
        if (o instanceof AssumesClause) {
            return this.add((AssumesClause)o);
        }
        throw new IllegalArgumentException();
    }

    @CanIgnoreReturnValue
    public BehaviorBuilder add(EnsuresClause ens) {
        this.ensuresClause = this.ensuresClause.and(ens);
        return this;
    }

    @CanIgnoreReturnValue
    public BehaviorBuilder add(RequiresClause req) {
        this.requiresClause = this.requiresClause.and(req);
        return this;
    }

    @CanIgnoreReturnValue
    public BehaviorBuilder add(AssumesClause ass) {
        this.assumesClause = this.assumesClause.and(ass);
        return this;
    }

    @CanIgnoreReturnValue
    public BehaviorBuilder addAll(Collection<?> clauses) {
        for (Object clause : clauses) {
            this.add(clause);
        }
        return this;
    }

    public Behavior build() {
        assert (this.behaviorName != null) : "Behavior needs a name";
        return new Behavior(this.behaviorName, this.ensuresClause, this.requiresClause, this.assumesClause);
    }
}

