/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.acsl;

import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLArrayAccess;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLBinaryTerm;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLCast;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLIdentifier;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLIntegerLiteral;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLLogicalPredicate;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLPredicate;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLPredicateVisitor;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLResult;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLSimplePredicate;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLStringLiteral;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLTerm;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLTermVisitor;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLTernaryCondition;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLUnaryTerm;
import org.sosy_lab.cpachecker.cfa.ast.acsl.Binder;
import org.sosy_lab.cpachecker.cfa.ast.acsl.BoundIdentifier;
import org.sosy_lab.cpachecker.cfa.ast.acsl.PredicateAt;
import org.sosy_lab.cpachecker.cfa.ast.acsl.TermAt;
import org.sosy_lab.cpachecker.exceptions.NoException;

public class BinderApplicationVisitor
implements ACSLTermVisitor<ACSLTerm, NoException>,
ACSLPredicateVisitor<ACSLPredicate, NoException> {
    private Set<Binder> binders;
    private Binder.Quantifier quantifier;

    public BinderApplicationVisitor(Set<Binder> pBinders, Binder.Quantifier pQuantifier) {
        this.binders = pBinders;
        this.quantifier = pQuantifier;
    }

    @Override
    public ACSLPredicate visitTrue() {
        return ACSLPredicate.getTrue();
    }

    @Override
    public ACSLPredicate visitFalse() {
        return ACSLPredicate.getFalse();
    }

    @Override
    public ACSLPredicate visit(ACSLSimplePredicate pred) {
        return new ACSLSimplePredicate(pred.getTerm().accept(this), pred.isNegated());
    }

    @Override
    public ACSLPredicate visit(ACSLLogicalPredicate pred) {
        return new ACSLLogicalPredicate(pred.getLeft().accept(this), pred.getRight().accept(this), pred.getOperator(), pred.isNegated());
    }

    @Override
    public ACSLPredicate visit(ACSLTernaryCondition pred) {
        return new ACSLTernaryCondition(pred.getCondition().accept(this), pred.getThen().accept(this), pred.getOtherwise().accept(this), pred.isNegated());
    }

    @Override
    public ACSLPredicate visit(PredicateAt pred) {
        return new PredicateAt(pred.getInner().accept(this), pred.getLabel(), pred.isNegated());
    }

    @Override
    public ACSLTerm visit(TermAt term) {
        return new TermAt(term.getInner().accept(this), term.getLabel());
    }

    @Override
    public ACSLTerm visit(ACSLBinaryTerm term) {
        return new ACSLBinaryTerm(term.getLeft().accept(this), term.getRight().accept(this), term.getOperator());
    }

    @Override
    public ACSLTerm visit(ACSLUnaryTerm term) {
        return new ACSLUnaryTerm(term.getInnerTerm().accept(this), term.getOperator());
    }

    @Override
    public ACSLTerm visit(ACSLArrayAccess term) {
        return new ACSLArrayAccess(term.getArray().accept(this), term.getIndex().accept(this));
    }

    @Override
    public ACSLTerm visit(BoundIdentifier term) {
        return term;
    }

    @Override
    public ACSLTerm visit(ACSLCast term) {
        return new ACSLCast(term.getType(), term.getTerm().accept(this));
    }

    @Override
    public ACSLTerm visit(ACSLIdentifier term) {
        for (Binder binder : this.binders) {
            if (!binder.getVariables().contains(term.getName())) continue;
            return new BoundIdentifier(term.getName(), term.getFunctionName(), binder.getType(), this.quantifier);
        }
        return term;
    }

    @Override
    public ACSLTerm visit(ACSLIntegerLiteral term) {
        return term;
    }

    @Override
    public ACSLTerm visit(ACSLResult term) {
        return term;
    }

    @Override
    public ACSLTerm visit(ACSLStringLiteral term) {
        return term;
    }
}

