/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.acsl;

import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLTerm;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLTermVisitor;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLType;
import org.sosy_lab.cpachecker.cfa.ast.acsl.Binder;

public class BoundIdentifier
implements ACSLTerm {
    private final String name;
    private final String functionName;
    private final ACSLType type;
    private final Binder.Quantifier quantifier;

    public BoundIdentifier(String pName, String pFunctionName, ACSLType pType, Binder.Quantifier pQuantifier) {
        this.name = pName;
        this.functionName = pFunctionName;
        this.type = pType;
        this.quantifier = pQuantifier;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o instanceof BoundIdentifier) {
            BoundIdentifier other = (BoundIdentifier)o;
            return this.name.equals(other.name);
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.name.hashCode() * this.name.hashCode() + 17;
    }

    public String getName() {
        return this.name;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public ACSLType getType() {
        return this.type;
    }

    public Binder.Quantifier getQuantifier() {
        return this.quantifier;
    }

    @Override
    public boolean isAllowedIn(Class<?> clauseType) {
        return true;
    }

    @Override
    public <R, X extends Exception> R accept(ACSLTermVisitor<R, X> visitor) throws X {
        return visitor.visit(this);
    }
}

