/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.acsl;

import com.google.common.base.Joiner;
import java.util.List;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLBinaryOperator;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLLogicalPredicate;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLPredicate;
import org.sosy_lab.cpachecker.cfa.ast.acsl.Behavior;

public class CompletenessClause {
    private final List<Behavior> behaviors;
    private final RelationKind kind;

    public CompletenessClause(List<Behavior> pBehaviors, RelationKind pKind) {
        this.behaviors = pBehaviors;
        this.kind = pKind;
    }

    private ACSLPredicate makePredicateRepresentation() {
        ACSLPredicate predicateRepresentation;
        if (this.kind.equals((Object)RelationKind.COMPLETE)) {
            predicateRepresentation = ACSLPredicate.getFalse();
            for (Behavior behavior : this.behaviors) {
                predicateRepresentation = new ACSLLogicalPredicate(predicateRepresentation, behavior.getAssumesClause().getPredicate(), ACSLBinaryOperator.OR);
            }
        } else if (this.kind.equals((Object)RelationKind.DISJOINT)) {
            predicateRepresentation = ACSLPredicate.getTrue();
            for (Behavior behavior1 : this.behaviors) {
                for (Behavior behavior2 : this.behaviors) {
                    if (behavior1 == behavior2) continue;
                    ACSLPredicate notBoth = new ACSLLogicalPredicate(behavior1.getAssumesClause().getPredicate(), behavior2.getAssumesClause().getPredicate(), ACSLBinaryOperator.AND).negate();
                    predicateRepresentation = new ACSLLogicalPredicate(predicateRepresentation, notBoth, ACSLBinaryOperator.AND);
                }
            }
        } else {
            throw new AssertionError((Object)("Unknown kind: " + this.kind));
        }
        return predicateRepresentation;
    }

    public ACSLPredicate getPredicateRepresentation() {
        return this.makePredicateRepresentation();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (!this.behaviors.isEmpty()) {
            builder.append(' ');
            Joiner.on((String)", ").appendTo(builder, this.behaviors.stream().map(x -> x.getName()).iterator());
        }
        builder.append(';');
        return this.kind.toString() + builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CompletenessClause)) {
            return false;
        }
        CompletenessClause that = (CompletenessClause)other;
        return Objects.equals(this.behaviors, that.behaviors) && this.kind == that.kind;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.behaviors, this.kind});
    }

    public static enum RelationKind {
        COMPLETE("complete"),
        DISJOINT("disjoint");

        private final String kindName;

        private RelationKind(String pKindName) {
            this.kindName = pKindName;
        }

        public String toString() {
            return this.kindName + " behaviors";
        }
    }
}

