/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.acsl;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLPredicate;
import org.sosy_lab.cpachecker.cfa.ast.acsl.Behavior;
import org.sosy_lab.cpachecker.cfa.ast.acsl.CompletenessClause;
import org.sosy_lab.cpachecker.cfa.ast.acsl.EnsuresClause;
import org.sosy_lab.cpachecker.cfa.ast.acsl.FunctionContract;
import org.sosy_lab.cpachecker.cfa.ast.acsl.RequiresClause;

public class ContractBuilder {
    private EnsuresClause ensuresClause = new EnsuresClause(ACSLPredicate.getTrue());
    private RequiresClause requiresClause = new RequiresClause(ACSLPredicate.getTrue());
    private final List<Behavior> behaviors = new ArrayList<Behavior>();
    private final List<CompletenessClause> completenessClauses = new ArrayList<CompletenessClause>();

    @CanIgnoreReturnValue
    public ContractBuilder add(Object o) {
        if (o instanceof RequiresClause) {
            return this.add((RequiresClause)o);
        }
        if (o instanceof EnsuresClause) {
            return this.add((EnsuresClause)o);
        }
        if (o instanceof Behavior) {
            return this.add((Behavior)o);
        }
        if (o instanceof CompletenessClause) {
            return this.add((CompletenessClause)o);
        }
        throw new IllegalArgumentException();
    }

    @CanIgnoreReturnValue
    public ContractBuilder add(EnsuresClause ens) {
        this.ensuresClause = this.ensuresClause.and(ens);
        return this;
    }

    @CanIgnoreReturnValue
    public ContractBuilder add(RequiresClause req) {
        this.requiresClause = this.requiresClause.and(req);
        return this;
    }

    @CanIgnoreReturnValue
    public ContractBuilder add(Behavior behavior) {
        this.behaviors.add(behavior);
        return this;
    }

    @CanIgnoreReturnValue
    public ContractBuilder add(CompletenessClause completenessClause) {
        this.completenessClauses.add(completenessClause);
        return this;
    }

    @CanIgnoreReturnValue
    public ContractBuilder addAll(Collection<?> clauses) {
        for (Object clause : clauses) {
            this.add(clause);
        }
        return this;
    }

    public FunctionContract build() {
        return new FunctionContract(this.requiresClause, this.ensuresClause, this.behaviors, this.completenessClauses);
    }
}

