/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.acsl;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLAnnotation;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLBinaryOperator;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLLogicalPredicate;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLPredicate;
import org.sosy_lab.cpachecker.cfa.ast.acsl.Behavior;
import org.sosy_lab.cpachecker.cfa.ast.acsl.CompletenessClause;
import org.sosy_lab.cpachecker.cfa.ast.acsl.EnsuresClause;
import org.sosy_lab.cpachecker.cfa.ast.acsl.RequiresClause;

public class FunctionContract
implements ACSLAnnotation {
    private final RequiresClause requiresClause;
    private final EnsuresClause ensuresClause;
    private final ImmutableList<Behavior> behaviors;
    private final ImmutableList<CompletenessClause> completenessClauses;
    private final boolean usePreStateRepresentation;

    FunctionContract(RequiresClause req, EnsuresClause ens, List<Behavior> pBehaviors, List<CompletenessClause> pCompletenessClauses) {
        this(req, ens, pBehaviors, pCompletenessClauses, false);
    }

    private FunctionContract(RequiresClause req, EnsuresClause ens, List<Behavior> pBehaviors, List<CompletenessClause> pCompletenessClauses, boolean pUsePreStateRepresentation) {
        this.requiresClause = new RequiresClause(req.getPredicate().simplify());
        this.ensuresClause = new EnsuresClause(ens.getPredicate().simplify());
        this.behaviors = ImmutableList.copyOf(pBehaviors);
        this.completenessClauses = ImmutableList.copyOf(pCompletenessClauses);
        this.usePreStateRepresentation = pUsePreStateRepresentation;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.requiresClause.toString()).append('\n').append(this.ensuresClause.toString()).append('\n');
        Joiner.on((char)'\n').appendTo(builder, this.behaviors.stream().map(x -> x.toString()).iterator());
        Joiner.on((char)'\n').appendTo(builder, this.completenessClauses.stream().map(x -> x.toString()).iterator());
        return builder.toString();
    }

    @Override
    public ACSLPredicate getPredicateRepresentation() {
        return this.usePreStateRepresentation ? this.getPreStateRepresentation() : this.getPostStateRepresentation();
    }

    private ACSLPredicate getPreStateRepresentation() {
        ACSLPredicate preStatePredicate = this.requiresClause.getPredicate();
        for (Behavior behavior : this.behaviors) {
            ACSLPredicate behaviorPredicate = behavior.getPreStatePredicate();
            preStatePredicate = new ACSLLogicalPredicate(preStatePredicate, behaviorPredicate, ACSLBinaryOperator.AND);
        }
        return preStatePredicate;
    }

    private ACSLPredicate getPostStateRepresentation() {
        ACSLPredicate postStatePredicate = this.ensuresClause.getPredicate();
        for (Behavior behavior : this.behaviors) {
            ACSLPredicate behaviorPredicate = behavior.getPostStatePredicate();
            postStatePredicate = new ACSLLogicalPredicate(postStatePredicate, behaviorPredicate, ACSLBinaryOperator.AND);
        }
        return postStatePredicate;
    }

    @Override
    public ACSLPredicate getCompletenessPredicate() {
        ACSLPredicate completenessPredicate = ACSLPredicate.getTrue();
        for (CompletenessClause completenessClause : this.completenessClauses) {
            completenessPredicate = new ACSLLogicalPredicate(completenessPredicate, completenessClause.getPredicateRepresentation(), ACSLBinaryOperator.AND);
        }
        return completenessPredicate;
    }

    public boolean isPreStateRepresentation() {
        return this.usePreStateRepresentation;
    }

    public RequiresClause getRequires() {
        return this.requiresClause;
    }

    public EnsuresClause getEnsures() {
        return this.ensuresClause;
    }

    @Override
    public List<Behavior> getDeclaredBehaviors() {
        return this.behaviors;
    }

    @Override
    public List<Behavior> getReferencedBehaviors() {
        return ImmutableList.of();
    }

    public List<CompletenessClause> getCompletenessClauses() {
        return this.completenessClauses;
    }

    public FunctionContract getCopyForPreState() {
        return new FunctionContract(this.requiresClause, this.ensuresClause, (List<Behavior>)this.behaviors, (List<CompletenessClause>)this.completenessClauses, true);
    }

    public FunctionContract getCopyForPostState() {
        return new FunctionContract(this.requiresClause, this.ensuresClause, (List<Behavior>)this.behaviors, (List<CompletenessClause>)this.completenessClauses, false);
    }

    public int hashCode() {
        int hash = 17 * this.requiresClause.hashCode() * this.ensuresClause.hashCode();
        for (Behavior behavior : this.behaviors) {
            hash *= behavior.hashCode();
        }
        for (CompletenessClause completenessClause : this.completenessClauses) {
            hash *= completenessClause.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FunctionContract) {
            FunctionContract other = (FunctionContract)obj;
            return this.requiresClause.equals(other.requiresClause) && this.ensuresClause.equals(other.ensuresClause) && this.behaviors.equals(other.behaviors) && this.completenessClauses.equals(other.completenessClauses);
        }
        return false;
    }
}

