/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.acsl;

import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CProgramScope;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLArrayAccess;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLBinaryTerm;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLCast;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLIdentifier;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLIntegerLiteral;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLLogicalPredicate;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLPredicateVisitor;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLResult;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLSimplePredicate;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLStringLiteral;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLTermVisitor;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLTernaryCondition;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLUnaryTerm;
import org.sosy_lab.cpachecker.cfa.ast.acsl.BoundIdentifier;
import org.sosy_lab.cpachecker.cfa.ast.acsl.PredicateAt;
import org.sosy_lab.cpachecker.cfa.ast.acsl.TermAt;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.exceptions.NoException;

public class IdentifierCheckingVisitor
implements ACSLTermVisitor<Boolean, NoException>,
ACSLPredicateVisitor<Boolean, NoException> {
    private final CFA cfa;
    private final LogManager logger;

    public IdentifierCheckingVisitor(CFA pCfa, LogManager pLogger) {
        this.cfa = pCfa;
        this.logger = pLogger;
    }

    @Override
    public Boolean visitTrue() {
        return true;
    }

    @Override
    public Boolean visitFalse() {
        return true;
    }

    @Override
    public Boolean visit(ACSLSimplePredicate pred) {
        return pred.getTerm().accept(this);
    }

    @Override
    public Boolean visit(ACSLLogicalPredicate pred) {
        return pred.getLeft().accept(this) != false && pred.getRight().accept(this) != false;
    }

    @Override
    public Boolean visit(ACSLTernaryCondition pred) {
        return pred.getCondition().accept(this) != false && pred.getThen().accept(this) != false && pred.getOtherwise().accept(this) != false;
    }

    @Override
    public Boolean visit(PredicateAt pred) {
        return pred.getInner().accept(this);
    }

    @Override
    public Boolean visit(ACSLBinaryTerm term) {
        return term.getLeft().accept(this) != false && term.getRight().accept(this) != false;
    }

    @Override
    public Boolean visit(ACSLUnaryTerm term) {
        return term.getInnerTerm().accept(this);
    }

    @Override
    public Boolean visit(ACSLArrayAccess term) {
        return term.getArray().accept(this) != false && term.getIndex().accept(this) != false;
    }

    @Override
    public Boolean visit(TermAt term) {
        return term.getInner().accept(this);
    }

    @Override
    public Boolean visit(ACSLResult term) {
        return this.cfa.getFunctionHead(term.getFunctionName()).getReturnVariable().isPresent();
    }

    @Override
    public Boolean visit(ACSLCast term) {
        return term.getTerm().accept(this);
    }

    @Override
    public Boolean visit(BoundIdentifier term) {
        return true;
    }

    @Override
    public Boolean visit(ACSLIdentifier term) {
        CProgramScope scope = new CProgramScope(this.cfa, this.logger);
        CSimpleDeclaration variableDeclaration = scope.lookupVariable(term.getName());
        return variableDeclaration != null;
    }

    @Override
    public Boolean visit(ACSLIntegerLiteral term) {
        return true;
    }

    @Override
    public Boolean visit(ACSLStringLiteral term) {
        return true;
    }
}

