/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.acsl;

import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLBuiltin;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLDefaultLabel;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLLabel;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLPredicate;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLPredicateVisitor;
import org.sosy_lab.cpachecker.cfa.ast.acsl.EnsuresClause;

public class PredicateAt
extends ACSLPredicate
implements ACSLBuiltin {
    private final ACSLPredicate inner;
    private final ACSLLabel label;

    public PredicateAt(ACSLPredicate pInner, ACSLLabel pLabel) {
        this(pInner, pLabel, false);
    }

    public PredicateAt(ACSLPredicate pInner, ACSLLabel pLabel, boolean negated) {
        super(negated);
        this.inner = pInner;
        this.label = pLabel;
    }

    public ACSLPredicate getInner() {
        return this.inner;
    }

    public ACSLLabel getLabel() {
        return this.label;
    }

    public String toString() {
        return "\\at(" + this.inner + ", " + this.label + ")";
    }

    @Override
    public int hashCode() {
        return 7 * this.inner.hashCode();
    }

    @Override
    public ACSLPredicate negate() {
        return new PredicateAt(this.inner, this.label, !this.isNegated());
    }

    @Override
    public ACSLPredicate simplify() {
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PredicateAt) {
            PredicateAt other = (PredicateAt)obj;
            return this.inner.equals(other.inner) && this.label.equals(other.label);
        }
        return false;
    }

    @Override
    public boolean isAllowedIn(Class<?> clauseType) {
        if (this.label.equals(ACSLDefaultLabel.OLD)) {
            return clauseType.equals(EnsuresClause.class) && this.inner.isAllowedIn(clauseType);
        }
        return this.inner.isAllowedIn(clauseType);
    }

    @Override
    public <R, X extends Exception> R accept(ACSLPredicateVisitor<R, X> visitor) throws X {
        return visitor.visit(this);
    }
}

