/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.acsl;

import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLAnnotation;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLBinaryOperator;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLBuiltinCollectingVisitor;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLLogicalPredicate;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLPredicate;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLResult;
import org.sosy_lab.cpachecker.cfa.ast.acsl.Behavior;
import org.sosy_lab.cpachecker.cfa.ast.acsl.CompletenessClause;
import org.sosy_lab.cpachecker.cfa.ast.acsl.EnsuresClause;
import org.sosy_lab.cpachecker.cfa.ast.acsl.FunctionContract;
import org.sosy_lab.cpachecker.cfa.ast.acsl.RequiresClause;

public class StatementContract
implements ACSLAnnotation {
    private final RequiresClause requiresClause;
    private final EnsuresClause ensuresClause;
    private final ImmutableList<Behavior> enclosingBehaviors;
    private final ImmutableList<Behavior> ownBehaviors;
    private final ImmutableList<CompletenessClause> completenessClauses;
    private final boolean usePreStateRepresentation;

    private StatementContract(RequiresClause req, EnsuresClause ens, List<Behavior> enclosing, List<Behavior> own, List<CompletenessClause> pCompletenessClauses) {
        this(req, ens, enclosing, own, pCompletenessClauses, false);
    }

    private StatementContract(RequiresClause req, EnsuresClause ens, List<Behavior> enclosing, List<Behavior> own, List<CompletenessClause> pCompletenessClauses, boolean pUsePreStateRepresentation) {
        this.requiresClause = req;
        this.ensuresClause = ens;
        this.enclosingBehaviors = ImmutableList.copyOf(enclosing);
        this.ownBehaviors = ImmutableList.copyOf(own);
        this.completenessClauses = ImmutableList.copyOf(pCompletenessClauses);
        this.usePreStateRepresentation = pUsePreStateRepresentation;
    }

    static StatementContract fromFunctionContract(List<Behavior> enclosing, FunctionContract fcontract) {
        ACSLBuiltinCollectingVisitor visitor = new ACSLBuiltinCollectingVisitor();
        assert (FluentIterable.from((Iterable)((Iterable)fcontract.getEnsures().getPredicate().accept(visitor))).filter(ACSLResult.class).isEmpty()) : "\\result is only allowed in function contracts";
        return new StatementContract(fcontract.getRequires(), fcontract.getEnsures(), enclosing, fcontract.getDeclaredBehaviors(), fcontract.getCompletenessClauses());
    }

    @Override
    public List<Behavior> getDeclaredBehaviors() {
        return this.ownBehaviors;
    }

    @Override
    public List<Behavior> getReferencedBehaviors() {
        return this.enclosingBehaviors;
    }

    public boolean isPreStateRepresentation() {
        return this.usePreStateRepresentation;
    }

    @Override
    public ACSLPredicate getPredicateRepresentation() {
        return this.usePreStateRepresentation ? this.getPreStateRepresentation() : this.getPostStateRepresentation();
    }

    private ACSLPredicate getPreStateRepresentation() {
        if (!this.enclosingBehaviors.isEmpty()) {
            return ACSLPredicate.getTrue();
        }
        ACSLPredicate preStatePredicate = this.requiresClause.getPredicate();
        for (Behavior behavior : this.ownBehaviors) {
            ACSLPredicate behaviorPredicate = behavior.getPreStatePredicate();
            preStatePredicate = new ACSLLogicalPredicate(preStatePredicate, behaviorPredicate, ACSLBinaryOperator.AND);
        }
        return preStatePredicate;
    }

    private ACSLPredicate getPostStateRepresentation() {
        if (!this.enclosingBehaviors.isEmpty()) {
            return ACSLPredicate.getTrue();
        }
        ACSLPredicate postStatePredicate = this.ensuresClause.getPredicate();
        for (Behavior behavior : this.ownBehaviors) {
            ACSLPredicate behaviorPredicate = behavior.getPostStatePredicate();
            postStatePredicate = new ACSLLogicalPredicate(postStatePredicate, behaviorPredicate, ACSLBinaryOperator.AND);
        }
        return postStatePredicate;
    }

    @Override
    public ACSLPredicate getCompletenessPredicate() {
        ACSLPredicate completenessPredicate = ACSLPredicate.getTrue();
        for (CompletenessClause completenessClause : this.completenessClauses) {
            completenessPredicate = new ACSLLogicalPredicate(completenessPredicate, completenessClause.getPredicateRepresentation(), ACSLBinaryOperator.AND);
        }
        return completenessPredicate;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (!this.enclosingBehaviors.isEmpty()) {
            builder.append("for ");
            Joiner.on((String)", ").appendTo(builder, this.enclosingBehaviors.stream().map(x -> x.getName()).iterator());
            builder.append(":\n");
        }
        builder.append(this.requiresClause.toString()).append('\n').append(this.ensuresClause.toString());
        for (Behavior b : this.ownBehaviors) {
            builder.append('\n').append(b.toString());
        }
        for (CompletenessClause c : this.completenessClauses) {
            builder.append('\n').append(c.toString());
        }
        return builder.toString();
    }

    public StatementContract getCopyForPreState() {
        return new StatementContract(this.requiresClause, this.ensuresClause, (List<Behavior>)this.enclosingBehaviors, (List<Behavior>)this.ownBehaviors, (List<CompletenessClause>)this.completenessClauses, true);
    }

    public StatementContract getCopyForPostState() {
        return new StatementContract(this.requiresClause, this.ensuresClause, (List<Behavior>)this.enclosingBehaviors, (List<Behavior>)this.ownBehaviors, (List<CompletenessClause>)this.completenessClauses, false);
    }

    public int hashCode() {
        int hash = 23 * this.requiresClause.hashCode() * this.ensuresClause.hashCode();
        for (Behavior behavior : this.enclosingBehaviors) {
            hash *= behavior.hashCode();
        }
        for (Behavior behavior : this.ownBehaviors) {
            hash *= behavior.hashCode();
        }
        for (CompletenessClause completenessClause : this.completenessClauses) {
            hash *= completenessClause.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StatementContract) {
            StatementContract other = (StatementContract)obj;
            return this.requiresClause.equals(other.requiresClause) && this.ensuresClause.equals(other.ensuresClause) && this.enclosingBehaviors.equals(other.enclosingBehaviors) && this.ownBehaviors.equals(other.ownBehaviors) && this.completenessClauses.equals(other.completenessClauses);
        }
        return false;
    }
}

