/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.acsl.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.truth.Truth;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CFACreator;
import org.sosy_lab.cpachecker.cfa.CFAWithACSLAnnotations;
import org.sosy_lab.cpachecker.util.test.TestDataTools;

@RunWith(value=Parameterized.class)
public class ACSLParserTest {
    private static final String TEST_DIR = "test/programs/acsl/";
    private final String programName;
    private final int expectedAnnotations;
    private final CFACreator cfaCreator;

    public ACSLParserTest(String pProgramName, int pExpectedAnnotations) throws InvalidConfigurationException {
        this.programName = pProgramName;
        this.expectedAnnotations = pExpectedAnnotations;
        Configuration config = TestDataTools.configurationForTest().loadFromResource(ACSLParserTest.class, "acslToWitness.properties").build();
        this.cfaCreator = new CFACreator(config, LogManager.createTestLogManager(), ShutdownNotifier.createDummy());
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        ImmutableList.Builder b = ImmutableList.builder();
        b.add((Object)ACSLParserTest.task("abs.c", 1));
        b.add((Object)ACSLParserTest.task("abs2.c", 1));
        b.add((Object)ACSLParserTest.task("even.c", 1));
        b.add((Object)ACSLParserTest.task("even2.c", 1));
        b.add((Object)ACSLParserTest.task("nested.c", 2));
        b.add((Object)ACSLParserTest.task("simple.c", 3));
        b.add((Object)ACSLParserTest.task("badVariable.c", 0));
        b.add((Object)ACSLParserTest.task("statements.c", 4));
        b.add((Object)ACSLParserTest.task("inv_for.c", 1));
        b.add((Object)ACSLParserTest.task("inv_short-for.c", 1));
        b.add((Object)ACSLParserTest.task("after_if.c", 1));
        b.add((Object)ACSLParserTest.task("after_else.c", 1));
        b.add((Object)ACSLParserTest.task("after_loop.c", 1));
        b.add((Object)ACSLParserTest.task("after_loop2.c", 1));
        b.add((Object)ACSLParserTest.task("at_end.c", 1));
        b.add((Object)ACSLParserTest.task("end_of_do_while.c", 1));
        b.add((Object)ACSLParserTest.task("after_for_loop.c", 1));
        b.add((Object)ACSLParserTest.task("after_for_loop2.c", 1));
        b.add((Object)ACSLParserTest.task("in_middle.c", 1));
        b.add((Object)ACSLParserTest.task("traps.c", 2));
        b.add((Object)ACSLParserTest.task("empty.c", 1));
        b.add((Object)ACSLParserTest.task("no_annotations.c", 0));
        b.add((Object)ACSLParserTest.task("badBehavior.c", 0));
        return b.build();
    }

    private static Object[] task(String program, int expectedAnnotations) {
        return new Object[]{program, expectedAnnotations};
    }

    @Test
    public void annotationParsingProducesExpectedNumberOfAnnotations() throws Exception {
        ImmutableList files = ImmutableList.of((Object)Path.of(TEST_DIR, this.programName).toString());
        CFA cfa = this.cfaCreator.parseFileAndCreateCFA((List<String>)files);
        if (cfa instanceof CFAWithACSLAnnotations) {
            CFAWithACSLAnnotations cfaWithLocs = (CFAWithACSLAnnotations)cfa;
            ImmutableSet annotations = ImmutableSet.copyOf((Collection)cfaWithLocs.getEdgesToAnnotations().values());
            Truth.assertThat((Iterable)annotations).hasSize(this.expectedAnnotations);
        } else {
            Truth.assertThat((Integer)this.expectedAnnotations).isEqualTo((Object)0);
        }
    }
}

