/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.acsl.util;

import com.google.common.collect.FluentIterable;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.acsl.util.SyntacticBlock;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class FunctionBlock
implements SyntacticBlock {
    private final FunctionEntryNode function;

    public FunctionBlock(FunctionEntryNode pFunction) {
        this.function = pFunction;
    }

    @Override
    public boolean isFunction() {
        return true;
    }

    @Override
    public boolean isLoop() {
        return false;
    }

    @Override
    public int getStartOffset() {
        return this.function.getFileLocation().getNodeOffset();
    }

    @Override
    public int getEndOffset() {
        return this.function.getFileLocation().getNodeOffset() + this.function.getFileLocation().getNodeLength();
    }

    public FluentIterable<CFAEdge> getEnteringEdges() {
        return CFAUtils.enteringEdges(this.function);
    }

    public FluentIterable<CFAEdge> getLeavingEdges() {
        return CFAUtils.leavingEdges(this.function);
    }

    @Override
    public Set<CFANode> getContainedNodes() {
        CFATraversal traversal = CFATraversal.dfs();
        traversal = traversal.ignoreFunctionCalls();
        return traversal.collectNodesReachableFromTo(this.function, this.function.getExitNode());
    }
}

