/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.acsl.util;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.acsl.util.SyntacticBlock;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class StatementBlock
implements SyntacticBlock {
    private final int startOffset;
    private final int endOffset;
    private final boolean isLoop;
    private final CFANode firstNode;
    private final Set<CFANode> endNodes = new HashSet<CFANode>();
    private final Set<CFANode> containedNodes = new HashSet<CFANode>();
    private final Set<CFAEdge> enteringEdges = new HashSet<CFAEdge>();
    private final Set<CFAEdge> leavingEdges = new HashSet<CFAEdge>();

    public StatementBlock(int pStartOffset, int pEndOffset, boolean pIsLoop, CFANode first, CFANode next) {
        this.startOffset = pStartOffset;
        this.endOffset = pEndOffset;
        this.isLoop = pIsLoop;
        this.firstNode = first;
        this.endNodes.add(next);
    }

    @Override
    public boolean isFunction() {
        return false;
    }

    @Override
    public boolean isLoop() {
        return this.isLoop;
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public Iterable<CFAEdge> getEnteringEdges() {
        return this.enteringEdges;
    }

    @Override
    public Iterable<CFAEdge> getLeavingEdges() {
        return this.leavingEdges;
    }

    @Override
    public Set<CFANode> getContainedNodes() {
        return this.containedNodes;
    }

    boolean computeSets(Collection<CFANode> nodes) {
        this.endNodes.removeIf(node -> !nodes.contains(node));
        if (!nodes.contains(this.firstNode) || this.endNodes.isEmpty()) {
            return false;
        }
        CFAUtils.enteringEdges(this.firstNode).copyInto(this.enteringEdges);
        if (this.endNodes.size() == 1 && this.endNodes.contains(this.firstNode)) {
            return true;
        }
        HashSet<CFAEdge> visited = new HashSet<CFAEdge>();
        ArrayDeque<CFAEdge> waitlist = new ArrayDeque<CFAEdge>(this.enteringEdges);
        while (!waitlist.isEmpty()) {
            CFAEdge currentEdge = (CFAEdge)waitlist.poll();
            if (visited.contains(currentEdge)) continue;
            visited.add(currentEdge);
            if (currentEdge instanceof CFunctionCallEdge) {
                CFunctionSummaryEdge summaryEdge = ((CFunctionCallEdge)currentEdge).getSummaryEdge();
                CFAUtils.enteringEdges(summaryEdge.getSuccessor()).copyInto(waitlist);
                continue;
            }
            CFANode successor = currentEdge.getSuccessor();
            if (this.endNodes.contains(successor)) {
                this.leavingEdges.add(currentEdge);
                continue;
            }
            this.containedNodes.add(successor);
            CFAUtils.leavingEdges(successor).copyInto(waitlist);
        }
        return true;
    }

    public void addEndNode(CFANode node) {
        this.endNodes.add(node);
    }
}

