/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.acsl.util;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.acsl.util.SyntacticBlock;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class SyntacticBlockStructure {
    private final ImmutableSet<SyntacticBlock> blocks;

    SyntacticBlockStructure(Collection<SyntacticBlock> pBlocks) {
        this.blocks = ImmutableSet.copyOf(pBlocks);
    }

    public SyntacticBlock getInnermostBlockOf(FileLocation location) {
        SyntacticBlock innermostBlock = null;
        for (SyntacticBlock block : this.blocks) {
            if (block.getStartOffset() > location.getNodeOffset() || location.getNodeOffset() >= block.getEndOffset() || innermostBlock != null && !innermostBlock.contains(block)) continue;
            innermostBlock = block;
        }
        return innermostBlock;
    }

    private boolean ignoreEdge(CFAEdge edge) {
        return edge instanceof CFunctionCallEdge || edge.getFileLocation().equals(FileLocation.DUMMY) || edge.getDescription().contains("__CPAchecker_TMP");
    }

    public Iterable<CFAEdge> getPrevEdges(SyntacticBlock pBlock, FileLocation location) {
        CFAEdge edge;
        HashSet<CFAEdge> edges = new HashSet<CFAEdge>();
        for (CFANode node : pBlock.getContainedNodes()) {
            CFAUtils.enteringEdges(node).copyInto(edges);
            CFAUtils.leavingEdges(node).copyInto(edges);
        }
        edges.removeIf(this::ignoreEdge);
        ArrayList<CFAEdge> sortedEdges = new ArrayList<CFAEdge>(edges);
        sortedEdges.sort(Comparator.comparingInt(pEdge -> pEdge.getFileLocation().getNodeOffset()));
        CFAEdge prev = null;
        Iterator iterator = sortedEdges.iterator();
        while (iterator.hasNext() && (edge = (CFAEdge)iterator.next()).getFileLocation().getNodeOffset() <= location.getNodeOffset()) {
            prev = edge;
        }
        if (prev == null) {
            return ImmutableSet.of();
        }
        SyntacticBlock innermostBlockOfPrevEdge = this.getInnermostBlockOf(prev.getFileLocation());
        if (innermostBlockOfPrevEdge.equals(pBlock)) {
            return CFAUtils.enteringEdges(prev.getSuccessor());
        }
        SyntacticBlock lastBlock = null;
        for (SyntacticBlock block : this.blocks) {
            if (!block.getContainedNodes().contains(prev.getPredecessor()) || block.getEndOffset() >= location.getNodeOffset() || lastBlock != null && !block.contains(lastBlock)) continue;
            lastBlock = block;
        }
        assert (lastBlock != null) : "Previous edge is allegedly in another block, but no such block was found";
        return lastBlock.getLeavingEdges();
    }

    public CFAEdge getNextEdge(SyntacticBlock block, FileLocation location) {
        HashSet<CFAEdge> edges = new HashSet<CFAEdge>();
        for (CFANode node : block.getContainedNodes()) {
            CFAUtils.enteringEdges(node).copyInto(edges);
            CFAUtils.leavingEdges(node).copyInto(edges);
        }
        edges.removeIf(this::ignoreEdge);
        ArrayList<CFAEdge> sortedEdges = new ArrayList<CFAEdge>(edges);
        sortedEdges.sort(Comparator.comparingInt(pEdge -> pEdge.getFileLocation().getNodeOffset()));
        for (CFAEdge edge : sortedEdges) {
            if (edge.getFileLocation().getNodeOffset() <= location.getNodeOffset()) continue;
            return edge;
        }
        return null;
    }
}

