/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.acsl.util;

import com.google.common.collect.FluentIterable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.acsl.util.StatementBlock;
import org.sosy_lab.cpachecker.cfa.ast.acsl.util.SyntacticBlock;
import org.sosy_lab.cpachecker.cfa.ast.acsl.util.SyntacticBlockStructure;

public class SyntacticBlockStructureBuilder {
    private final CFA cfa;
    private final Set<SyntacticBlock> blocks = new HashSet<SyntacticBlock>();

    public SyntacticBlockStructureBuilder(CFA pCFA) {
        this.cfa = pCFA;
    }

    public SyntacticBlockStructure build() {
        this.computeSetsForStatementBlocks();
        return new SyntacticBlockStructure(this.blocks);
    }

    public void addAll(Collection<SyntacticBlock> pBlocks) {
        this.blocks.addAll(pBlocks);
    }

    private void computeSetsForStatementBlocks() {
        HashSet<StatementBlock> toRemove = new HashSet<StatementBlock>();
        for (StatementBlock block : FluentIterable.from(this.blocks).filter(StatementBlock.class)) {
            if (block.computeSets(this.cfa.getAllNodes())) continue;
            toRemove.add(block);
        }
        this.blocks.removeAll(toRemove);
    }
}

