/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.c;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.cfa.ast.AbstractExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNodeVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.types.c.CType;

public class CAddressOfLabelExpression
extends AbstractExpression
implements CExpression {
    private static final long serialVersionUID = -6304788147442934412L;
    private final String label;

    public CAddressOfLabelExpression(FileLocation pFileLocation, CType pType, String pLabelName) {
        super(pFileLocation, pType);
        this.label = (String)Preconditions.checkNotNull((Object)pLabelName);
    }

    public String getLabelName() {
        return this.label;
    }

    @Override
    public CType getExpressionType() {
        return (CType)super.getExpressionType();
    }

    @Override
    public String toASTString(boolean pQualified) {
        return this.toASTString();
    }

    @Override
    public String toASTString() {
        return "&&" + this.label;
    }

    @Override
    public <R, X extends Exception> R accept(CExpressionVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(CRightHandSideVisitor<R, X> v) throws X {
        return v.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(CAstNodeVisitor<R, X> pV) throws X {
        return pV.visit(this);
    }

    @Override
    public int hashCode() {
        return this.label.hashCode() * 31 + super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CAddressOfLabelExpression)) {
            return false;
        }
        return this.label.equals(((CAddressOfLabelExpression)obj).label) && super.equals(obj);
    }
}

