/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.ast.c;

import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNodeVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatorVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;

public class CArrayRangeDesignator
extends CDesignator {
    private static final long serialVersionUID = -2956484289176841585L;
    private final AExpression rangeFloor;
    private final AExpression rangeCeiling;

    public CArrayRangeDesignator(FileLocation pFileLocation, CExpression pRangeFloor, CExpression pRangeCeiling) {
        super(pFileLocation);
        this.rangeFloor = pRangeFloor;
        this.rangeCeiling = pRangeCeiling;
    }

    public CExpression getFloorExpression() {
        return (CExpression)this.rangeFloor;
    }

    public CExpression getCeilExpression() {
        return (CExpression)this.rangeCeiling;
    }

    @Override
    public String toASTString(boolean pQualified) {
        return "[" + this.rangeFloor.toASTString(pQualified) + " ... " + this.rangeCeiling.toASTString(pQualified) + "]";
    }

    @Override
    public String toParenthesizedASTString(boolean pQualified) {
        return this.toASTString(pQualified);
    }

    @Override
    public <R, X extends Exception> R accept(CDesignatorVisitor<R, X> pV) throws X {
        return pV.visit(this);
    }

    @Override
    public <R, X extends Exception> R accept(CAstNodeVisitor<R, X> pV) throws X {
        return pV.visit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.rangeCeiling);
        result = 31 * result + Objects.hashCode(this.rangeFloor);
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CArrayRangeDesignator) || !super.equals(obj)) {
            return false;
        }
        CArrayRangeDesignator other = (CArrayRangeDesignator)obj;
        return Objects.equals(other.rangeCeiling, this.rangeCeiling) && Objects.equals(other.rangeFloor, this.rangeFloor);
    }
}

